// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeLDAPSSettingsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// Specifies the number of items that should be displayed on one page.
	Limit *int64 `min:"1" type:"integer"`

	// The type of next token used for pagination.
	NextToken *string `type:"string"`

	// The type of LDAP security to enable. Currently only the value Client is supported.
	Type LDAPSType `type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeLDAPSSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLDAPSSettingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeLDAPSSettingsInput"}

	if s.DirectoryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryId"))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeLDAPSSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Information about LDAP security for the specified directory, including status
	// of enablement, state last updated date time, and the reason for the state.
	LDAPSSettingsInfo []LDAPSSettingInfo `type:"list"`

	// The next token used to retrieve the LDAPS settings if the number of setting
	// types exceeds page limit and there is another page.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeLDAPSSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeLDAPSSettings = "DescribeLDAPSSettings"

// DescribeLDAPSSettingsRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Describes the status of LDAP security for the specified directory.
//
//    // Example sending a request using DescribeLDAPSSettingsRequest.
//    req := client.DescribeLDAPSSettingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeLDAPSSettings
func (c *Client) DescribeLDAPSSettingsRequest(input *DescribeLDAPSSettingsInput) DescribeLDAPSSettingsRequest {
	op := &aws.Operation{
		Name:       opDescribeLDAPSSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLDAPSSettingsInput{}
	}

	req := c.newRequest(op, input, &DescribeLDAPSSettingsOutput{})

	return DescribeLDAPSSettingsRequest{Request: req, Input: input, Copy: c.DescribeLDAPSSettingsRequest}
}

// DescribeLDAPSSettingsRequest is the request type for the
// DescribeLDAPSSettings API operation.
type DescribeLDAPSSettingsRequest struct {
	*aws.Request
	Input *DescribeLDAPSSettingsInput
	Copy  func(*DescribeLDAPSSettingsInput) DescribeLDAPSSettingsRequest
}

// Send marshals and sends the DescribeLDAPSSettings API request.
func (r DescribeLDAPSSettingsRequest) Send(ctx context.Context) (*DescribeLDAPSSettingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeLDAPSSettingsResponse{
		DescribeLDAPSSettingsOutput: r.Request.Data.(*DescribeLDAPSSettingsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeLDAPSSettingsResponse is the response type for the
// DescribeLDAPSSettings API operation.
type DescribeLDAPSSettingsResponse struct {
	*DescribeLDAPSSettingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeLDAPSSettings request.
func (r *DescribeLDAPSSettingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
