// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RestoreTableFromBackupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the backup.
	//
	// BackupArn is a required field
	BackupArn *string `min:"37" type:"string" required:"true"`

	// The billing mode of the restored table.
	BillingModeOverride BillingMode `type:"string" enum:"true"`

	// List of global secondary indexes for the restored table. The indexes provided
	// should match existing secondary indexes. You can choose to exclude some or
	// all of the indexes at the time of restore.
	GlobalSecondaryIndexOverride []GlobalSecondaryIndex `type:"list"`

	// List of local secondary indexes for the restored table. The indexes provided
	// should match existing secondary indexes. You can choose to exclude some or
	// all of the indexes at the time of restore.
	LocalSecondaryIndexOverride []LocalSecondaryIndex `type:"list"`

	// Provisioned throughput settings for the restored table.
	ProvisionedThroughputOverride *ProvisionedThroughput `type:"structure"`

	// The new server-side encryption settings for the restored table.
	SSESpecificationOverride *SSESpecification `type:"structure"`

	// The name of the new table to which the backup must be restored.
	//
	// TargetTableName is a required field
	TargetTableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s RestoreTableFromBackupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreTableFromBackupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RestoreTableFromBackupInput"}

	if s.BackupArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("BackupArn"))
	}
	if s.BackupArn != nil && len(*s.BackupArn) < 37 {
		invalidParams.Add(aws.NewErrParamMinLen("BackupArn", 37))
	}

	if s.TargetTableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetTableName"))
	}
	if s.TargetTableName != nil && len(*s.TargetTableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetTableName", 3))
	}
	if s.GlobalSecondaryIndexOverride != nil {
		for i, v := range s.GlobalSecondaryIndexOverride {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GlobalSecondaryIndexOverride", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.LocalSecondaryIndexOverride != nil {
		for i, v := range s.LocalSecondaryIndexOverride {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LocalSecondaryIndexOverride", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.ProvisionedThroughputOverride != nil {
		if err := s.ProvisionedThroughputOverride.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedThroughputOverride", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RestoreTableFromBackupOutput struct {
	_ struct{} `type:"structure"`

	// The description of the table created from an existing backup.
	TableDescription *TableDescription `type:"structure"`
}

// String returns the string representation
func (s RestoreTableFromBackupOutput) String() string {
	return awsutil.Prettify(s)
}

const opRestoreTableFromBackup = "RestoreTableFromBackup"

// RestoreTableFromBackupRequest returns a request value for making API operation for
// Amazon DynamoDB.
//
// Creates a new table from an existing backup. Any number of users can execute
// up to 4 concurrent restores (any type of restore) in a given account.
//
// You can call RestoreTableFromBackup at a maximum rate of 10 times per second.
//
// You must manually set up the following on the restored table:
//
//    * Auto scaling policies
//
//    * IAM policies
//
//    * Amazon CloudWatch metrics and alarms
//
//    * Tags
//
//    * Stream settings
//
//    * Time to Live (TTL) settings
//
//    // Example sending a request using RestoreTableFromBackupRequest.
//    req := client.RestoreTableFromBackupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/RestoreTableFromBackup
func (c *Client) RestoreTableFromBackupRequest(input *RestoreTableFromBackupInput) RestoreTableFromBackupRequest {
	op := &aws.Operation{
		Name:       opRestoreTableFromBackup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreTableFromBackupInput{}
	}

	req := c.newRequest(op, input, &RestoreTableFromBackupOutput{})

	if req.Config.EnableEndpointDiscovery {
		de := discovererDescribeEndpoints{
			Client:        c,
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": &req.Operation.Name,
			},
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(aws.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}

	return RestoreTableFromBackupRequest{Request: req, Input: input, Copy: c.RestoreTableFromBackupRequest}
}

// RestoreTableFromBackupRequest is the request type for the
// RestoreTableFromBackup API operation.
type RestoreTableFromBackupRequest struct {
	*aws.Request
	Input *RestoreTableFromBackupInput
	Copy  func(*RestoreTableFromBackupInput) RestoreTableFromBackupRequest
}

// Send marshals and sends the RestoreTableFromBackup API request.
func (r RestoreTableFromBackupRequest) Send(ctx context.Context) (*RestoreTableFromBackupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RestoreTableFromBackupResponse{
		RestoreTableFromBackupOutput: r.Request.Data.(*RestoreTableFromBackupOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RestoreTableFromBackupResponse is the response type for the
// RestoreTableFromBackup API operation.
type RestoreTableFromBackupResponse struct {
	*RestoreTableFromBackupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RestoreTableFromBackup request.
func (r *RestoreTableFromBackupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
