// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ebs

import (
	"context"
	"io"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type PutSnapshotBlockInput struct {
	_ struct{} `type:"structure" payload:"BlockData"`

	// The data to write to the block.
	//
	// The block data is not signed as part of the Signature Version 4 signing process.
	// As a result, you must generate and provide a Base64-encoded SHA256 checksum
	// for the block data using the x-amz-Checksum header. Also, you must specify
	// the checksum algorithm using the x-amz-Checksum-Algorithm header. The checksum
	// that you provide is part of the Signature Version 4 signing process. It is
	// validated against a checksum generated by Amazon EBS to ensure the validity
	// and authenticity of the data. If the checksums do not correspond, the request
	// fails. For more information, see Using checksums with the EBS direct APIs
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-checksums)
	// in the Amazon Elastic Compute Cloud User Guide.
	//
	// To use an non-seekable io.Reader for this request wrap the io.Reader with
	// "aws.ReadSeekCloser". The SDK will not retry request errors for non-seekable
	// readers. This will allow the SDK to send the reader's payload as chunked
	// transfer encoding.
	//
	// BlockData is a required field
	BlockData io.ReadSeeker `type:"blob" required:"true" sensitive:"true"`

	// The block index of the block in which to write the data. A block index is
	// the offset position of a block within a snapshot, and it is used to identify
	// the block. To identify the logical offset of the data in the logical volume,
	// multiply the block index with the block size (Block index * 512 bytes).
	//
	// BlockIndex is a required field
	BlockIndex *int64 `location:"uri" locationName:"blockIndex" type:"integer" required:"true"`

	// A Base64-encoded SHA256 checksum of the data. Only SHA256 checksums are supported.
	//
	// Checksum is a required field
	Checksum *string `location:"header" locationName:"x-amz-Checksum" type:"string" required:"true"`

	// The algorithm used to generate the checksum. Currently, the only supported
	// algorithm is SHA256.
	//
	// ChecksumAlgorithm is a required field
	ChecksumAlgorithm ChecksumAlgorithm `location:"header" locationName:"x-amz-Checksum-Algorithm" type:"string" required:"true" enum:"true"`

	// The size of the data to write to the block, in bytes. Currently, the only
	// supported size is 524288.
	//
	// Valid values: 524288
	//
	// DataLength is a required field
	DataLength *int64 `location:"header" locationName:"x-amz-Data-Length" type:"integer" required:"true"`

	// The progress of the write process, as a percentage.
	Progress *int64 `location:"header" locationName:"x-amz-Progress" type:"integer"`

	// The ID of the snapshot.
	//
	// SnapshotId is a required field
	SnapshotId *string `location:"uri" locationName:"snapshotId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutSnapshotBlockInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSnapshotBlockInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutSnapshotBlockInput"}

	if s.BlockData == nil {
		invalidParams.Add(aws.NewErrParamRequired("BlockData"))
	}

	if s.BlockIndex == nil {
		invalidParams.Add(aws.NewErrParamRequired("BlockIndex"))
	}

	if s.Checksum == nil {
		invalidParams.Add(aws.NewErrParamRequired("Checksum"))
	}
	if len(s.ChecksumAlgorithm) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ChecksumAlgorithm"))
	}

	if s.DataLength == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataLength"))
	}

	if s.SnapshotId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SnapshotId"))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SnapshotId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutSnapshotBlockInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Checksum != nil {
		v := *s.Checksum

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-Checksum", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ChecksumAlgorithm) > 0 {
		v := s.ChecksumAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-Checksum-Algorithm", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.DataLength != nil {
		v := *s.DataLength

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-Data-Length", protocol.Int64Value(v), metadata)
	}
	if s.Progress != nil {
		v := *s.Progress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-Progress", protocol.Int64Value(v), metadata)
	}
	if s.BlockIndex != nil {
		v := *s.BlockIndex

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "blockIndex", protocol.Int64Value(v), metadata)
	}
	if s.SnapshotId != nil {
		v := *s.SnapshotId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "snapshotId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BlockData != nil {
		v := s.BlockData

		metadata := protocol.Metadata{}
		e.SetStream(protocol.PayloadTarget, "BlockData", protocol.ReadSeekerStream{V: v}, metadata)
	}
	return nil
}

type PutSnapshotBlockOutput struct {
	_ struct{} `type:"structure"`

	// The SHA256 checksum generated for the block data by Amazon EBS.
	Checksum *string `location:"header" locationName:"x-amz-Checksum" type:"string"`

	// The algorithm used by Amazon EBS to generate the checksum.
	ChecksumAlgorithm ChecksumAlgorithm `location:"header" locationName:"x-amz-Checksum-Algorithm" type:"string" enum:"true"`
}

// String returns the string representation
func (s PutSnapshotBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutSnapshotBlockOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Checksum != nil {
		v := *s.Checksum

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-Checksum", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ChecksumAlgorithm) > 0 {
		v := s.ChecksumAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-Checksum-Algorithm", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

const opPutSnapshotBlock = "PutSnapshotBlock"

// PutSnapshotBlockRequest returns a request value for making API operation for
// Amazon Elastic Block Store.
//
// Writes a block of data to a block in the snapshot. If the specified block
// contains data, the existing data is overwritten. The target snapshot must
// be in the pending state.
//
// Data written to a snapshot must be aligned with 512-byte sectors.
//
//    // Example sending a request using PutSnapshotBlockRequest.
//    req := client.PutSnapshotBlockRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ebs-2019-11-02/PutSnapshotBlock
func (c *Client) PutSnapshotBlockRequest(input *PutSnapshotBlockInput) PutSnapshotBlockRequest {
	op := &aws.Operation{
		Name:       opPutSnapshotBlock,
		HTTPMethod: "PUT",
		HTTPPath:   "/snapshots/{snapshotId}/blocks/{blockIndex}",
	}

	if input == nil {
		input = &PutSnapshotBlockInput{}
	}

	req := c.newRequest(op, input, &PutSnapshotBlockOutput{})
	req.Handlers.Sign.Remove(v4.SignRequestHandler)
	handler := v4.BuildNamedHandler("v4.CustomSignerHandler", v4.WithUnsignedPayload)
	req.Handlers.Sign.PushFrontNamed(handler)

	return PutSnapshotBlockRequest{Request: req, Input: input, Copy: c.PutSnapshotBlockRequest}
}

// PutSnapshotBlockRequest is the request type for the
// PutSnapshotBlock API operation.
type PutSnapshotBlockRequest struct {
	*aws.Request
	Input *PutSnapshotBlockInput
	Copy  func(*PutSnapshotBlockInput) PutSnapshotBlockRequest
}

// Send marshals and sends the PutSnapshotBlock API request.
func (r PutSnapshotBlockRequest) Send(ctx context.Context) (*PutSnapshotBlockResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutSnapshotBlockResponse{
		PutSnapshotBlockOutput: r.Request.Data.(*PutSnapshotBlockOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutSnapshotBlockResponse is the response type for the
// PutSnapshotBlock API operation.
type PutSnapshotBlockResponse struct {
	*PutSnapshotBlockOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutSnapshotBlock request.
func (r *PutSnapshotBlockResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
