// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateClientVpnEndpointInput struct {
	_ struct{} `type:"structure"`

	// Information about the authentication method to be used to authenticate clients.
	//
	// AuthenticationOptions is a required field
	AuthenticationOptions []VpnAuthenticationRequest `locationName:"Authentication" type:"list" required:"true"`

	// The IPv4 address range, in CIDR notation, from which to assign client IP
	// addresses. The address range cannot overlap with the local CIDR of the VPC
	// in which the associated subnet is located, or the routes that you add manually.
	// The address range cannot be changed after the Client VPN endpoint has been
	// created. The CIDR block should be /22 or greater.
	//
	// ClientCidrBlock is a required field
	ClientCidrBlock *string `type:"string" required:"true"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. For more information, see How to Ensure Idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// Information about the client connection logging options.
	//
	// If you enable client connection logging, data about client connections is
	// sent to a Cloudwatch Logs log stream. The following information is logged:
	//
	//    * Client connection requests
	//
	//    * Client connection results (successful and unsuccessful)
	//
	//    * Reasons for unsuccessful client connection requests
	//
	//    * Client connection termination time
	//
	// ConnectionLogOptions is a required field
	ConnectionLogOptions *ConnectionLogOptions `type:"structure" required:"true"`

	// A brief description of the Client VPN endpoint.
	Description *string `type:"string"`

	// Information about the DNS servers to be used for DNS resolution. A Client
	// VPN endpoint can have up to two DNS servers. If no DNS server is specified,
	// the DNS address configured on the device is used for the DNS server.
	DnsServers []string `locationNameList:"item" type:"list"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The IDs of one or more security groups to apply to the target network. You
	// must also specify the ID of the VPC that contains the security groups.
	SecurityGroupIds []string `locationName:"SecurityGroupId" locationNameList:"item" type:"list"`

	// The ARN of the server certificate. For more information, see the AWS Certificate
	// Manager User Guide (https://docs.aws.amazon.com/acm/latest/userguide/).
	//
	// ServerCertificateArn is a required field
	ServerCertificateArn *string `type:"string" required:"true"`

	// Indicates whether split-tunnel is enabled on the AWS Client VPN endpoint.
	//
	// By default, split-tunnel on a VPN endpoint is disabled.
	//
	// For information about split-tunnel VPN endpoints, see Split-Tunnel AWS Client
	// VPN Endpoint (https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html)
	// in the AWS Client VPN Administrator Guide.
	SplitTunnel *bool `type:"boolean"`

	// The tags to apply to the Client VPN endpoint during creation.
	TagSpecifications []TagSpecification `locationName:"TagSpecification" locationNameList:"item" type:"list"`

	// The transport protocol to be used by the VPN session.
	//
	// Default value: udp
	TransportProtocol TransportProtocol `type:"string" enum:"true"`

	// The ID of the VPC to associate with the Client VPN endpoint. If no security
	// group IDs are specified in the request, the default security group for the
	// VPC is applied.
	VpcId *string `type:"string"`

	// The port number to assign to the Client VPN endpoint for TCP and UDP traffic.
	//
	// Valid Values: 443 | 1194
	//
	// Default Value: 443
	VpnPort *int64 `type:"integer"`
}

// String returns the string representation
func (s CreateClientVpnEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClientVpnEndpointInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateClientVpnEndpointInput"}

	if s.AuthenticationOptions == nil {
		invalidParams.Add(aws.NewErrParamRequired("AuthenticationOptions"))
	}

	if s.ClientCidrBlock == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientCidrBlock"))
	}

	if s.ConnectionLogOptions == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionLogOptions"))
	}

	if s.ServerCertificateArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerCertificateArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateClientVpnEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the Client VPN endpoint.
	ClientVpnEndpointId *string `locationName:"clientVpnEndpointId" type:"string"`

	// The DNS name to be used by clients when establishing their VPN session.
	DnsName *string `locationName:"dnsName" type:"string"`

	// The current state of the Client VPN endpoint.
	Status *VpnEndpointStatus `locationName:"status" type:"structure"`
}

// String returns the string representation
func (s CreateClientVpnEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateClientVpnEndpoint = "CreateClientVpnEndpoint"

// CreateClientVpnEndpointRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Creates a Client VPN endpoint. A Client VPN endpoint is the resource you
// create and configure to enable and manage client VPN sessions. It is the
// destination endpoint at which all client VPN sessions are terminated.
//
//    // Example sending a request using CreateClientVpnEndpointRequest.
//    req := client.CreateClientVpnEndpointRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpoint
func (c *Client) CreateClientVpnEndpointRequest(input *CreateClientVpnEndpointInput) CreateClientVpnEndpointRequest {
	op := &aws.Operation{
		Name:       opCreateClientVpnEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClientVpnEndpointInput{}
	}

	req := c.newRequest(op, input, &CreateClientVpnEndpointOutput{})

	return CreateClientVpnEndpointRequest{Request: req, Input: input, Copy: c.CreateClientVpnEndpointRequest}
}

// CreateClientVpnEndpointRequest is the request type for the
// CreateClientVpnEndpoint API operation.
type CreateClientVpnEndpointRequest struct {
	*aws.Request
	Input *CreateClientVpnEndpointInput
	Copy  func(*CreateClientVpnEndpointInput) CreateClientVpnEndpointRequest
}

// Send marshals and sends the CreateClientVpnEndpoint API request.
func (r CreateClientVpnEndpointRequest) Send(ctx context.Context) (*CreateClientVpnEndpointResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateClientVpnEndpointResponse{
		CreateClientVpnEndpointOutput: r.Request.Data.(*CreateClientVpnEndpointOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateClientVpnEndpointResponse is the response type for the
// CreateClientVpnEndpoint API operation.
type CreateClientVpnEndpointResponse struct {
	*CreateClientVpnEndpointOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateClientVpnEndpoint request.
func (r *CreateClientVpnEndpointResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
