// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateTransitGatewayMulticastDomainInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The tags for the transit gateway multicast domain.
	TagSpecifications []TagSpecification `locationName:"TagSpecification" locationNameList:"item" type:"list"`

	// The ID of the transit gateway.
	//
	// TransitGatewayId is a required field
	TransitGatewayId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTransitGatewayMulticastDomainInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTransitGatewayMulticastDomainInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateTransitGatewayMulticastDomainInput"}

	if s.TransitGatewayId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransitGatewayId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateTransitGatewayMulticastDomainOutput struct {
	_ struct{} `type:"structure"`

	// Information about the transit gateway multicast domain.
	TransitGatewayMulticastDomain *TransitGatewayMulticastDomain `locationName:"transitGatewayMulticastDomain" type:"structure"`
}

// String returns the string representation
func (s CreateTransitGatewayMulticastDomainOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateTransitGatewayMulticastDomain = "CreateTransitGatewayMulticastDomain"

// CreateTransitGatewayMulticastDomainRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Creates a multicast domain using the specified transit gateway.
//
// The transit gateway must be in the available state before you create a domain.
// Use DescribeTransitGateways (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html)
// to see the state of transit gateway.
//
//    // Example sending a request using CreateTransitGatewayMulticastDomainRequest.
//    req := client.CreateTransitGatewayMulticastDomainRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomain
func (c *Client) CreateTransitGatewayMulticastDomainRequest(input *CreateTransitGatewayMulticastDomainInput) CreateTransitGatewayMulticastDomainRequest {
	op := &aws.Operation{
		Name:       opCreateTransitGatewayMulticastDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayMulticastDomainInput{}
	}

	req := c.newRequest(op, input, &CreateTransitGatewayMulticastDomainOutput{})

	return CreateTransitGatewayMulticastDomainRequest{Request: req, Input: input, Copy: c.CreateTransitGatewayMulticastDomainRequest}
}

// CreateTransitGatewayMulticastDomainRequest is the request type for the
// CreateTransitGatewayMulticastDomain API operation.
type CreateTransitGatewayMulticastDomainRequest struct {
	*aws.Request
	Input *CreateTransitGatewayMulticastDomainInput
	Copy  func(*CreateTransitGatewayMulticastDomainInput) CreateTransitGatewayMulticastDomainRequest
}

// Send marshals and sends the CreateTransitGatewayMulticastDomain API request.
func (r CreateTransitGatewayMulticastDomainRequest) Send(ctx context.Context) (*CreateTransitGatewayMulticastDomainResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateTransitGatewayMulticastDomainResponse{
		CreateTransitGatewayMulticastDomainOutput: r.Request.Data.(*CreateTransitGatewayMulticastDomainOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateTransitGatewayMulticastDomainResponse is the response type for the
// CreateTransitGatewayMulticastDomain API operation.
type CreateTransitGatewayMulticastDomainResponse struct {
	*CreateTransitGatewayMulticastDomainOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateTransitGatewayMulticastDomain request.
func (r *CreateTransitGatewayMulticastDomainResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
