// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeSecurityGroupReferencesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The IDs of the security groups in your account.
	//
	// GroupId is a required field
	GroupId []string `locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeSecurityGroupReferencesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSecurityGroupReferencesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeSecurityGroupReferencesInput"}

	if s.GroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeSecurityGroupReferencesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the VPCs with the referencing security groups.
	SecurityGroupReferenceSet []SecurityGroupReference `locationName:"securityGroupReferenceSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeSecurityGroupReferencesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeSecurityGroupReferences = "DescribeSecurityGroupReferences"

// DescribeSecurityGroupReferencesRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// [VPC only] Describes the VPCs on the other side of a VPC peering connection
// that are referencing the security groups you've specified in this request.
//
//    // Example sending a request using DescribeSecurityGroupReferencesRequest.
//    req := client.DescribeSecurityGroupReferencesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroupReferences
func (c *Client) DescribeSecurityGroupReferencesRequest(input *DescribeSecurityGroupReferencesInput) DescribeSecurityGroupReferencesRequest {
	op := &aws.Operation{
		Name:       opDescribeSecurityGroupReferences,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSecurityGroupReferencesInput{}
	}

	req := c.newRequest(op, input, &DescribeSecurityGroupReferencesOutput{})

	return DescribeSecurityGroupReferencesRequest{Request: req, Input: input, Copy: c.DescribeSecurityGroupReferencesRequest}
}

// DescribeSecurityGroupReferencesRequest is the request type for the
// DescribeSecurityGroupReferences API operation.
type DescribeSecurityGroupReferencesRequest struct {
	*aws.Request
	Input *DescribeSecurityGroupReferencesInput
	Copy  func(*DescribeSecurityGroupReferencesInput) DescribeSecurityGroupReferencesRequest
}

// Send marshals and sends the DescribeSecurityGroupReferences API request.
func (r DescribeSecurityGroupReferencesRequest) Send(ctx context.Context) (*DescribeSecurityGroupReferencesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeSecurityGroupReferencesResponse{
		DescribeSecurityGroupReferencesOutput: r.Request.Data.(*DescribeSecurityGroupReferencesOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeSecurityGroupReferencesResponse is the response type for the
// DescribeSecurityGroupReferences API operation.
type DescribeSecurityGroupReferencesResponse struct {
	*DescribeSecurityGroupReferencesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeSecurityGroupReferences request.
func (r *DescribeSecurityGroupReferencesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
