// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeVpcEndpointServicePermissionsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters.
	//
	//    * principal - The ARN of the principal.
	//
	//    * principal-type - The principal type (All | Service | OrganizationUnit
	//    | Account | User | Role).
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The maximum number of results to return for the request in a single page.
	// The remaining results of the initial request can be seen by sending another
	// request with the returned NextToken value. This value can be between 5 and
	// 1,000; if MaxResults is given a value larger than 1,000, only 1,000 results
	// are returned.
	MaxResults *int64 `type:"integer"`

	// The token to retrieve the next page of results.
	NextToken *string `type:"string"`

	// The ID of the service.
	//
	// ServiceId is a required field
	ServiceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeVpcEndpointServicePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVpcEndpointServicePermissionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeVpcEndpointServicePermissionsInput"}

	if s.ServiceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeVpcEndpointServicePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// Information about one or more allowed principals.
	AllowedPrincipals []AllowedPrincipal `locationName:"allowedPrincipals" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeVpcEndpointServicePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeVpcEndpointServicePermissions = "DescribeVpcEndpointServicePermissions"

// DescribeVpcEndpointServicePermissionsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes the principals (service consumers) that are permitted to discover
// your VPC endpoint service.
//
//    // Example sending a request using DescribeVpcEndpointServicePermissionsRequest.
//    req := client.DescribeVpcEndpointServicePermissionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointServicePermissions
func (c *Client) DescribeVpcEndpointServicePermissionsRequest(input *DescribeVpcEndpointServicePermissionsInput) DescribeVpcEndpointServicePermissionsRequest {
	op := &aws.Operation{
		Name:       opDescribeVpcEndpointServicePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeVpcEndpointServicePermissionsInput{}
	}

	req := c.newRequest(op, input, &DescribeVpcEndpointServicePermissionsOutput{})

	return DescribeVpcEndpointServicePermissionsRequest{Request: req, Input: input, Copy: c.DescribeVpcEndpointServicePermissionsRequest}
}

// DescribeVpcEndpointServicePermissionsRequest is the request type for the
// DescribeVpcEndpointServicePermissions API operation.
type DescribeVpcEndpointServicePermissionsRequest struct {
	*aws.Request
	Input *DescribeVpcEndpointServicePermissionsInput
	Copy  func(*DescribeVpcEndpointServicePermissionsInput) DescribeVpcEndpointServicePermissionsRequest
}

// Send marshals and sends the DescribeVpcEndpointServicePermissions API request.
func (r DescribeVpcEndpointServicePermissionsRequest) Send(ctx context.Context) (*DescribeVpcEndpointServicePermissionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeVpcEndpointServicePermissionsResponse{
		DescribeVpcEndpointServicePermissionsOutput: r.Request.Data.(*DescribeVpcEndpointServicePermissionsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeVpcEndpointServicePermissionsRequestPaginator returns a paginator for DescribeVpcEndpointServicePermissions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeVpcEndpointServicePermissionsRequest(input)
//   p := ec2.NewDescribeVpcEndpointServicePermissionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeVpcEndpointServicePermissionsPaginator(req DescribeVpcEndpointServicePermissionsRequest) DescribeVpcEndpointServicePermissionsPaginator {
	return DescribeVpcEndpointServicePermissionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeVpcEndpointServicePermissionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeVpcEndpointServicePermissionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeVpcEndpointServicePermissionsPaginator struct {
	aws.Pager
}

func (p *DescribeVpcEndpointServicePermissionsPaginator) CurrentPage() *DescribeVpcEndpointServicePermissionsOutput {
	return p.Pager.CurrentPage().(*DescribeVpcEndpointServicePermissionsOutput)
}

// DescribeVpcEndpointServicePermissionsResponse is the response type for the
// DescribeVpcEndpointServicePermissions API operation.
type DescribeVpcEndpointServicePermissionsResponse struct {
	*DescribeVpcEndpointServicePermissionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeVpcEndpointServicePermissions request.
func (r *DescribeVpcEndpointServicePermissionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
