// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RejectTransitGatewayPeeringAttachmentInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the transit gateway peering attachment.
	//
	// TransitGatewayAttachmentId is a required field
	TransitGatewayAttachmentId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RejectTransitGatewayPeeringAttachmentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectTransitGatewayPeeringAttachmentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RejectTransitGatewayPeeringAttachmentInput"}

	if s.TransitGatewayAttachmentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransitGatewayAttachmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RejectTransitGatewayPeeringAttachmentOutput struct {
	_ struct{} `type:"structure"`

	// The transit gateway peering attachment.
	TransitGatewayPeeringAttachment *TransitGatewayPeeringAttachment `locationName:"transitGatewayPeeringAttachment" type:"structure"`
}

// String returns the string representation
func (s RejectTransitGatewayPeeringAttachmentOutput) String() string {
	return awsutil.Prettify(s)
}

const opRejectTransitGatewayPeeringAttachment = "RejectTransitGatewayPeeringAttachment"

// RejectTransitGatewayPeeringAttachmentRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Rejects a transit gateway peering attachment request.
//
//    // Example sending a request using RejectTransitGatewayPeeringAttachmentRequest.
//    req := client.RejectTransitGatewayPeeringAttachmentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RejectTransitGatewayPeeringAttachment
func (c *Client) RejectTransitGatewayPeeringAttachmentRequest(input *RejectTransitGatewayPeeringAttachmentInput) RejectTransitGatewayPeeringAttachmentRequest {
	op := &aws.Operation{
		Name:       opRejectTransitGatewayPeeringAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RejectTransitGatewayPeeringAttachmentInput{}
	}

	req := c.newRequest(op, input, &RejectTransitGatewayPeeringAttachmentOutput{})

	return RejectTransitGatewayPeeringAttachmentRequest{Request: req, Input: input, Copy: c.RejectTransitGatewayPeeringAttachmentRequest}
}

// RejectTransitGatewayPeeringAttachmentRequest is the request type for the
// RejectTransitGatewayPeeringAttachment API operation.
type RejectTransitGatewayPeeringAttachmentRequest struct {
	*aws.Request
	Input *RejectTransitGatewayPeeringAttachmentInput
	Copy  func(*RejectTransitGatewayPeeringAttachmentInput) RejectTransitGatewayPeeringAttachmentRequest
}

// Send marshals and sends the RejectTransitGatewayPeeringAttachment API request.
func (r RejectTransitGatewayPeeringAttachmentRequest) Send(ctx context.Context) (*RejectTransitGatewayPeeringAttachmentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RejectTransitGatewayPeeringAttachmentResponse{
		RejectTransitGatewayPeeringAttachmentOutput: r.Request.Data.(*RejectTransitGatewayPeeringAttachmentOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RejectTransitGatewayPeeringAttachmentResponse is the response type for the
// RejectTransitGatewayPeeringAttachment API operation.
type RejectTransitGatewayPeeringAttachmentResponse struct {
	*RejectTransitGatewayPeeringAttachmentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RejectTransitGatewayPeeringAttachment request.
func (r *RejectTransitGatewayPeeringAttachmentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
