// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type SearchTransitGatewayMulticastGroupsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters. The possible values are:
	//
	//    * group-ip-address - The IP address of the transit gateway multicast group.
	//
	//    * is-group-member - The resource is a group member. Valid values are true
	//    | false.
	//
	//    * is-group-source - The resource is a group source. Valid values are true
	//    | false.
	//
	//    * member-type - The member type. Valid values are igmp | static.
	//
	//    * resource-id - The ID of the resource.
	//
	//    * resource-type - The type of resource. Valid values are vpc | vpn | direct-connect-gateway
	//    | tgw-peering.
	//
	//    * source-type - The source type. Valid values are igmp | static.
	//
	//    * state - The state of the subnet association. Valid values are associated
	//    | associated | disassociated | disassociating.
	//
	//    * subnet-id - The ID of the subnet.
	//
	//    * transit-gateway-attachment-id - The id of the transit gateway attachment.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"5" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`

	// The ID of the transit gateway multicast domain.
	TransitGatewayMulticastDomainId *string `type:"string"`
}

// String returns the string representation
func (s SearchTransitGatewayMulticastGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchTransitGatewayMulticastGroupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SearchTransitGatewayMulticastGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SearchTransitGatewayMulticastGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the transit gateway multicast group.
	MulticastGroups []TransitGatewayMulticastGroup `locationName:"multicastGroups" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s SearchTransitGatewayMulticastGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opSearchTransitGatewayMulticastGroups = "SearchTransitGatewayMulticastGroups"

// SearchTransitGatewayMulticastGroupsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Searches one or more transit gateway multicast groups and returns the group
// membership information.
//
//    // Example sending a request using SearchTransitGatewayMulticastGroupsRequest.
//    req := client.SearchTransitGatewayMulticastGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/SearchTransitGatewayMulticastGroups
func (c *Client) SearchTransitGatewayMulticastGroupsRequest(input *SearchTransitGatewayMulticastGroupsInput) SearchTransitGatewayMulticastGroupsRequest {
	op := &aws.Operation{
		Name:       opSearchTransitGatewayMulticastGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchTransitGatewayMulticastGroupsInput{}
	}

	req := c.newRequest(op, input, &SearchTransitGatewayMulticastGroupsOutput{})

	return SearchTransitGatewayMulticastGroupsRequest{Request: req, Input: input, Copy: c.SearchTransitGatewayMulticastGroupsRequest}
}

// SearchTransitGatewayMulticastGroupsRequest is the request type for the
// SearchTransitGatewayMulticastGroups API operation.
type SearchTransitGatewayMulticastGroupsRequest struct {
	*aws.Request
	Input *SearchTransitGatewayMulticastGroupsInput
	Copy  func(*SearchTransitGatewayMulticastGroupsInput) SearchTransitGatewayMulticastGroupsRequest
}

// Send marshals and sends the SearchTransitGatewayMulticastGroups API request.
func (r SearchTransitGatewayMulticastGroupsRequest) Send(ctx context.Context) (*SearchTransitGatewayMulticastGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SearchTransitGatewayMulticastGroupsResponse{
		SearchTransitGatewayMulticastGroupsOutput: r.Request.Data.(*SearchTransitGatewayMulticastGroupsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewSearchTransitGatewayMulticastGroupsRequestPaginator returns a paginator for SearchTransitGatewayMulticastGroups.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.SearchTransitGatewayMulticastGroupsRequest(input)
//   p := ec2.NewSearchTransitGatewayMulticastGroupsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewSearchTransitGatewayMulticastGroupsPaginator(req SearchTransitGatewayMulticastGroupsRequest) SearchTransitGatewayMulticastGroupsPaginator {
	return SearchTransitGatewayMulticastGroupsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *SearchTransitGatewayMulticastGroupsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// SearchTransitGatewayMulticastGroupsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type SearchTransitGatewayMulticastGroupsPaginator struct {
	aws.Pager
}

func (p *SearchTransitGatewayMulticastGroupsPaginator) CurrentPage() *SearchTransitGatewayMulticastGroupsOutput {
	return p.Pager.CurrentPage().(*SearchTransitGatewayMulticastGroupsOutput)
}

// SearchTransitGatewayMulticastGroupsResponse is the response type for the
// SearchTransitGatewayMulticastGroups API operation.
type SearchTransitGatewayMulticastGroupsResponse struct {
	*SearchTransitGatewayMulticastGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SearchTransitGatewayMulticastGroups request.
func (r *SearchTransitGatewayMulticastGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
