// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteRepositoryPolicyInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID associated with the registry that contains the repository
	// policy to delete. If you do not specify a registry, the default registry
	// is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository that is associated with the repository policy
	// to delete.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRepositoryPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRepositoryPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteRepositoryPolicyInput"}

	if s.RepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteRepositoryPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The JSON repository policy that was deleted from the repository.
	PolicyText *string `locationName:"policyText" type:"string"`

	// The registry ID associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation
func (s DeleteRepositoryPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteRepositoryPolicy = "DeleteRepositoryPolicy"

// DeleteRepositoryPolicyRequest returns a request value for making API operation for
// Amazon EC2 Container Registry.
//
// Deletes the repository policy associated with the specified repository.
//
//    // Example sending a request using DeleteRepositoryPolicyRequest.
//    req := client.DeleteRepositoryPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRepositoryPolicy
func (c *Client) DeleteRepositoryPolicyRequest(input *DeleteRepositoryPolicyInput) DeleteRepositoryPolicyRequest {
	op := &aws.Operation{
		Name:       opDeleteRepositoryPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRepositoryPolicyInput{}
	}

	req := c.newRequest(op, input, &DeleteRepositoryPolicyOutput{})

	return DeleteRepositoryPolicyRequest{Request: req, Input: input, Copy: c.DeleteRepositoryPolicyRequest}
}

// DeleteRepositoryPolicyRequest is the request type for the
// DeleteRepositoryPolicy API operation.
type DeleteRepositoryPolicyRequest struct {
	*aws.Request
	Input *DeleteRepositoryPolicyInput
	Copy  func(*DeleteRepositoryPolicyInput) DeleteRepositoryPolicyRequest
}

// Send marshals and sends the DeleteRepositoryPolicy API request.
func (r DeleteRepositoryPolicyRequest) Send(ctx context.Context) (*DeleteRepositoryPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteRepositoryPolicyResponse{
		DeleteRepositoryPolicyOutput: r.Request.Data.(*DeleteRepositoryPolicyOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteRepositoryPolicyResponse is the response type for the
// DeleteRepositoryPolicy API operation.
type DeleteRepositoryPolicyResponse struct {
	*DeleteRepositoryPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteRepositoryPolicy request.
func (r *DeleteRepositoryPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
