// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecr

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
)

// WaitUntilImageScanComplete uses the Amazon ECR API operation
// DescribeImageScanFindings to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Client) WaitUntilImageScanComplete(ctx context.Context, input *DescribeImageScanFindingsInput, opts ...aws.WaiterOption) error {
	w := aws.Waiter{
		Name:        "WaitUntilImageScanComplete",
		MaxAttempts: 60,
		Delay:       aws.ConstantWaiterDelay(5 * time.Second),
		Acceptors: []aws.WaiterAcceptor{
			{
				State:   aws.SuccessWaiterState,
				Matcher: aws.PathWaiterMatch, Argument: "imageScanStatus.status",
				Expected: "COMPLETE",
			},
			{
				State:   aws.FailureWaiterState,
				Matcher: aws.PathWaiterMatch, Argument: "imageScanStatus.status",
				Expected: "FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []aws.Option) (*aws.Request, error) {
			var inCpy *DescribeImageScanFindingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req := c.DescribeImageScanFindingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req.Request, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.Wait(ctx)
}

// WaitUntilLifecyclePolicyPreviewComplete uses the Amazon ECR API operation
// GetLifecyclePolicyPreview to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Client) WaitUntilLifecyclePolicyPreviewComplete(ctx context.Context, input *GetLifecyclePolicyPreviewInput, opts ...aws.WaiterOption) error {
	w := aws.Waiter{
		Name:        "WaitUntilLifecyclePolicyPreviewComplete",
		MaxAttempts: 20,
		Delay:       aws.ConstantWaiterDelay(5 * time.Second),
		Acceptors: []aws.WaiterAcceptor{
			{
				State:   aws.SuccessWaiterState,
				Matcher: aws.PathWaiterMatch, Argument: "status",
				Expected: "COMPLETE",
			},
			{
				State:   aws.FailureWaiterState,
				Matcher: aws.PathWaiterMatch, Argument: "status",
				Expected: "FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []aws.Option) (*aws.Request, error) {
			var inCpy *GetLifecyclePolicyPreviewInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req := c.GetLifecyclePolicyPreviewRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req.Request, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.Wait(ctx)
}
