// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteCapacityProviderInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the capacity provider
	// to delete.
	//
	// CapacityProvider is a required field
	CapacityProvider *string `locationName:"capacityProvider" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCapacityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCapacityProviderInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteCapacityProviderInput"}

	if s.CapacityProvider == nil {
		invalidParams.Add(aws.NewErrParamRequired("CapacityProvider"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteCapacityProviderOutput struct {
	_ struct{} `type:"structure"`

	// The details of a capacity provider.
	CapacityProvider *CapacityProvider `locationName:"capacityProvider" type:"structure"`
}

// String returns the string representation
func (s DeleteCapacityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteCapacityProvider = "DeleteCapacityProvider"

// DeleteCapacityProviderRequest returns a request value for making API operation for
// Amazon EC2 Container Service.
//
// Deletes the specified capacity provider.
//
// The FARGATE and FARGATE_SPOT capacity providers are reserved and cannot be
// deleted. You can disassociate them from a cluster using either the PutClusterCapacityProviders
// API or by deleting the cluster.
//
// Prior to a capacity provider being deleted, the capacity provider must be
// removed from the capacity provider strategy from all services. The UpdateService
// API can be used to remove a capacity provider from a service's capacity provider
// strategy. When updating a service, the forceNewDeployment option can be used
// to ensure that any tasks using the Amazon EC2 instance capacity provided
// by the capacity provider are transitioned to use the capacity from the remaining
// capacity providers. Only capacity providers that are not associated with
// a cluster can be deleted. To remove a capacity provider from a cluster, you
// can either use PutClusterCapacityProviders or delete the cluster.
//
//    // Example sending a request using DeleteCapacityProviderRequest.
//    req := client.DeleteCapacityProviderRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteCapacityProvider
func (c *Client) DeleteCapacityProviderRequest(input *DeleteCapacityProviderInput) DeleteCapacityProviderRequest {
	op := &aws.Operation{
		Name:       opDeleteCapacityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCapacityProviderInput{}
	}

	req := c.newRequest(op, input, &DeleteCapacityProviderOutput{})

	return DeleteCapacityProviderRequest{Request: req, Input: input, Copy: c.DeleteCapacityProviderRequest}
}

// DeleteCapacityProviderRequest is the request type for the
// DeleteCapacityProvider API operation.
type DeleteCapacityProviderRequest struct {
	*aws.Request
	Input *DeleteCapacityProviderInput
	Copy  func(*DeleteCapacityProviderInput) DeleteCapacityProviderRequest
}

// Send marshals and sends the DeleteCapacityProvider API request.
func (r DeleteCapacityProviderRequest) Send(ctx context.Context) (*DeleteCapacityProviderResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteCapacityProviderResponse{
		DeleteCapacityProviderOutput: r.Request.Data.(*DeleteCapacityProviderOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteCapacityProviderResponse is the response type for the
// DeleteCapacityProvider API operation.
type DeleteCapacityProviderResponse struct {
	*DeleteCapacityProviderOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteCapacityProvider request.
func (r *DeleteCapacityProviderResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
