// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ecsiface provides an interface to enable mocking the Amazon EC2 Container Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package ecsiface

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/service/ecs"
)

// ClientAPI provides an interface to enable mocking the
// ecs.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon ECS.
//    func myFunc(svc ecsiface.ClientAPI) bool {
//        // Make svc.CreateCapacityProvider request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := ecs.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        ecsiface.ClientPI
//    }
//    func (m *mockClientClient) CreateCapacityProvider(input *ecs.CreateCapacityProviderInput) (*ecs.CreateCapacityProviderOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateCapacityProviderRequest(*ecs.CreateCapacityProviderInput) ecs.CreateCapacityProviderRequest

	CreateClusterRequest(*ecs.CreateClusterInput) ecs.CreateClusterRequest

	CreateServiceRequest(*ecs.CreateServiceInput) ecs.CreateServiceRequest

	CreateTaskSetRequest(*ecs.CreateTaskSetInput) ecs.CreateTaskSetRequest

	DeleteAccountSettingRequest(*ecs.DeleteAccountSettingInput) ecs.DeleteAccountSettingRequest

	DeleteAttributesRequest(*ecs.DeleteAttributesInput) ecs.DeleteAttributesRequest

	DeleteCapacityProviderRequest(*ecs.DeleteCapacityProviderInput) ecs.DeleteCapacityProviderRequest

	DeleteClusterRequest(*ecs.DeleteClusterInput) ecs.DeleteClusterRequest

	DeleteServiceRequest(*ecs.DeleteServiceInput) ecs.DeleteServiceRequest

	DeleteTaskSetRequest(*ecs.DeleteTaskSetInput) ecs.DeleteTaskSetRequest

	DeregisterContainerInstanceRequest(*ecs.DeregisterContainerInstanceInput) ecs.DeregisterContainerInstanceRequest

	DeregisterTaskDefinitionRequest(*ecs.DeregisterTaskDefinitionInput) ecs.DeregisterTaskDefinitionRequest

	DescribeCapacityProvidersRequest(*ecs.DescribeCapacityProvidersInput) ecs.DescribeCapacityProvidersRequest

	DescribeClustersRequest(*ecs.DescribeClustersInput) ecs.DescribeClustersRequest

	DescribeContainerInstancesRequest(*ecs.DescribeContainerInstancesInput) ecs.DescribeContainerInstancesRequest

	DescribeServicesRequest(*ecs.DescribeServicesInput) ecs.DescribeServicesRequest

	DescribeTaskDefinitionRequest(*ecs.DescribeTaskDefinitionInput) ecs.DescribeTaskDefinitionRequest

	DescribeTaskSetsRequest(*ecs.DescribeTaskSetsInput) ecs.DescribeTaskSetsRequest

	DescribeTasksRequest(*ecs.DescribeTasksInput) ecs.DescribeTasksRequest

	DiscoverPollEndpointRequest(*ecs.DiscoverPollEndpointInput) ecs.DiscoverPollEndpointRequest

	ListAccountSettingsRequest(*ecs.ListAccountSettingsInput) ecs.ListAccountSettingsRequest

	ListAttributesRequest(*ecs.ListAttributesInput) ecs.ListAttributesRequest

	ListClustersRequest(*ecs.ListClustersInput) ecs.ListClustersRequest

	ListContainerInstancesRequest(*ecs.ListContainerInstancesInput) ecs.ListContainerInstancesRequest

	ListServicesRequest(*ecs.ListServicesInput) ecs.ListServicesRequest

	ListTagsForResourceRequest(*ecs.ListTagsForResourceInput) ecs.ListTagsForResourceRequest

	ListTaskDefinitionFamiliesRequest(*ecs.ListTaskDefinitionFamiliesInput) ecs.ListTaskDefinitionFamiliesRequest

	ListTaskDefinitionsRequest(*ecs.ListTaskDefinitionsInput) ecs.ListTaskDefinitionsRequest

	ListTasksRequest(*ecs.ListTasksInput) ecs.ListTasksRequest

	PutAccountSettingRequest(*ecs.PutAccountSettingInput) ecs.PutAccountSettingRequest

	PutAccountSettingDefaultRequest(*ecs.PutAccountSettingDefaultInput) ecs.PutAccountSettingDefaultRequest

	PutAttributesRequest(*ecs.PutAttributesInput) ecs.PutAttributesRequest

	PutClusterCapacityProvidersRequest(*ecs.PutClusterCapacityProvidersInput) ecs.PutClusterCapacityProvidersRequest

	RegisterContainerInstanceRequest(*ecs.RegisterContainerInstanceInput) ecs.RegisterContainerInstanceRequest

	RegisterTaskDefinitionRequest(*ecs.RegisterTaskDefinitionInput) ecs.RegisterTaskDefinitionRequest

	RunTaskRequest(*ecs.RunTaskInput) ecs.RunTaskRequest

	StartTaskRequest(*ecs.StartTaskInput) ecs.StartTaskRequest

	StopTaskRequest(*ecs.StopTaskInput) ecs.StopTaskRequest

	SubmitAttachmentStateChangesRequest(*ecs.SubmitAttachmentStateChangesInput) ecs.SubmitAttachmentStateChangesRequest

	SubmitContainerStateChangeRequest(*ecs.SubmitContainerStateChangeInput) ecs.SubmitContainerStateChangeRequest

	SubmitTaskStateChangeRequest(*ecs.SubmitTaskStateChangeInput) ecs.SubmitTaskStateChangeRequest

	TagResourceRequest(*ecs.TagResourceInput) ecs.TagResourceRequest

	UntagResourceRequest(*ecs.UntagResourceInput) ecs.UntagResourceRequest

	UpdateClusterSettingsRequest(*ecs.UpdateClusterSettingsInput) ecs.UpdateClusterSettingsRequest

	UpdateContainerAgentRequest(*ecs.UpdateContainerAgentInput) ecs.UpdateContainerAgentRequest

	UpdateContainerInstancesStateRequest(*ecs.UpdateContainerInstancesStateInput) ecs.UpdateContainerInstancesStateRequest

	UpdateServiceRequest(*ecs.UpdateServiceInput) ecs.UpdateServiceRequest

	UpdateServicePrimaryTaskSetRequest(*ecs.UpdateServicePrimaryTaskSetInput) ecs.UpdateServicePrimaryTaskSetRequest

	UpdateTaskSetRequest(*ecs.UpdateTaskSetInput) ecs.UpdateTaskSetRequest

	WaitUntilServicesInactive(context.Context, *ecs.DescribeServicesInput, ...aws.WaiterOption) error

	WaitUntilServicesStable(context.Context, *ecs.DescribeServicesInput, ...aws.WaiterOption) error

	WaitUntilTasksRunning(context.Context, *ecs.DescribeTasksInput, ...aws.WaiterOption) error

	WaitUntilTasksStopped(context.Context, *ecs.DescribeTasksInput, ...aws.WaiterOption) error
}

var _ ClientAPI = (*ecs.Client)(nil)
