// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package efs_test

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/aws/awserr"
	"github.com/aws/aws-sdk-go-v2/aws/external"
	"github.com/aws/aws-sdk-go-v2/service/efs"
)

var _ aws.Config

// To create a new file system
//
// This operation creates a new file system with the default generalpurpose performance
// mode.
func ExampleClient_CreateFileSystemRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := efs.New(cfg)
	input := &efs.CreateFileSystemInput{
		CreationToken:   aws.String("tokenstring"),
		PerformanceMode: efs.PerformanceModeGeneralPurpose,
		Tags: []efs.Tag{
			{
				Key:   aws.String("Name"),
				Value: aws.String("MyFileSystem"),
			},
		},
	}

	req := svc.CreateFileSystemRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case efs.ErrCodeBadRequest:
				fmt.Println(efs.ErrCodeBadRequest, aerr.Error())
			case efs.ErrCodeInternalServerError:
				fmt.Println(efs.ErrCodeInternalServerError, aerr.Error())
			case efs.ErrCodeFileSystemAlreadyExists:
				fmt.Println(efs.ErrCodeFileSystemAlreadyExists, aerr.Error())
			case efs.ErrCodeFileSystemLimitExceeded:
				fmt.Println(efs.ErrCodeFileSystemLimitExceeded, aerr.Error())
			case efs.ErrCodeInsufficientThroughputCapacity:
				fmt.Println(efs.ErrCodeInsufficientThroughputCapacity, aerr.Error())
			case efs.ErrCodeThroughputLimitExceeded:
				fmt.Println(efs.ErrCodeThroughputLimitExceeded, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a new mount target
//
// This operation creates a new mount target for an EFS file system.
func ExampleClient_CreateMountTargetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := efs.New(cfg)
	input := &efs.CreateMountTargetInput{
		FileSystemId: aws.String("fs-01234567"),
		SubnetId:     aws.String("subnet-1234abcd"),
	}

	req := svc.CreateMountTargetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case efs.ErrCodeBadRequest:
				fmt.Println(efs.ErrCodeBadRequest, aerr.Error())
			case efs.ErrCodeInternalServerError:
				fmt.Println(efs.ErrCodeInternalServerError, aerr.Error())
			case efs.ErrCodeFileSystemNotFound:
				fmt.Println(efs.ErrCodeFileSystemNotFound, aerr.Error())
			case efs.ErrCodeIncorrectFileSystemLifeCycleState:
				fmt.Println(efs.ErrCodeIncorrectFileSystemLifeCycleState, aerr.Error())
			case efs.ErrCodeMountTargetConflict:
				fmt.Println(efs.ErrCodeMountTargetConflict, aerr.Error())
			case efs.ErrCodeSubnetNotFound:
				fmt.Println(efs.ErrCodeSubnetNotFound, aerr.Error())
			case efs.ErrCodeNoFreeAddressesInSubnet:
				fmt.Println(efs.ErrCodeNoFreeAddressesInSubnet, aerr.Error())
			case efs.ErrCodeIpAddressInUse:
				fmt.Println(efs.ErrCodeIpAddressInUse, aerr.Error())
			case efs.ErrCodeNetworkInterfaceLimitExceeded:
				fmt.Println(efs.ErrCodeNetworkInterfaceLimitExceeded, aerr.Error())
			case efs.ErrCodeSecurityGroupLimitExceeded:
				fmt.Println(efs.ErrCodeSecurityGroupLimitExceeded, aerr.Error())
			case efs.ErrCodeSecurityGroupNotFound:
				fmt.Println(efs.ErrCodeSecurityGroupNotFound, aerr.Error())
			case efs.ErrCodeUnsupportedAvailabilityZone:
				fmt.Println(efs.ErrCodeUnsupportedAvailabilityZone, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a new tag
//
// This operation creates a new tag for an EFS file system.
func ExampleClient_CreateTagsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := efs.New(cfg)
	input := &efs.CreateTagsInput{
		FileSystemId: aws.String("fs-01234567"),
		Tags: []efs.Tag{
			{
				Key:   aws.String("Name"),
				Value: aws.String("MyFileSystem"),
			},
		},
	}

	req := svc.CreateTagsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case efs.ErrCodeBadRequest:
				fmt.Println(efs.ErrCodeBadRequest, aerr.Error())
			case efs.ErrCodeInternalServerError:
				fmt.Println(efs.ErrCodeInternalServerError, aerr.Error())
			case efs.ErrCodeFileSystemNotFound:
				fmt.Println(efs.ErrCodeFileSystemNotFound, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a file system
//
// This operation deletes an EFS file system.
func ExampleClient_DeleteFileSystemRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := efs.New(cfg)
	input := &efs.DeleteFileSystemInput{
		FileSystemId: aws.String("fs-01234567"),
	}

	req := svc.DeleteFileSystemRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case efs.ErrCodeBadRequest:
				fmt.Println(efs.ErrCodeBadRequest, aerr.Error())
			case efs.ErrCodeInternalServerError:
				fmt.Println(efs.ErrCodeInternalServerError, aerr.Error())
			case efs.ErrCodeFileSystemNotFound:
				fmt.Println(efs.ErrCodeFileSystemNotFound, aerr.Error())
			case efs.ErrCodeFileSystemInUse:
				fmt.Println(efs.ErrCodeFileSystemInUse, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a mount target
//
// This operation deletes a mount target.
func ExampleClient_DeleteMountTargetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := efs.New(cfg)
	input := &efs.DeleteMountTargetInput{
		MountTargetId: aws.String("fsmt-12340abc"),
	}

	req := svc.DeleteMountTargetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case efs.ErrCodeBadRequest:
				fmt.Println(efs.ErrCodeBadRequest, aerr.Error())
			case efs.ErrCodeInternalServerError:
				fmt.Println(efs.ErrCodeInternalServerError, aerr.Error())
			case efs.ErrCodeDependencyTimeout:
				fmt.Println(efs.ErrCodeDependencyTimeout, aerr.Error())
			case efs.ErrCodeMountTargetNotFound:
				fmt.Println(efs.ErrCodeMountTargetNotFound, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete tags for an EFS file system
//
// This operation deletes tags for an EFS file system.
func ExampleClient_DeleteTagsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := efs.New(cfg)
	input := &efs.DeleteTagsInput{
		FileSystemId: aws.String("fs-01234567"),
		TagKeys: []string{
			"Name",
		},
	}

	req := svc.DeleteTagsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case efs.ErrCodeBadRequest:
				fmt.Println(efs.ErrCodeBadRequest, aerr.Error())
			case efs.ErrCodeInternalServerError:
				fmt.Println(efs.ErrCodeInternalServerError, aerr.Error())
			case efs.ErrCodeFileSystemNotFound:
				fmt.Println(efs.ErrCodeFileSystemNotFound, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe an EFS file system
//
// This operation describes all of the EFS file systems in an account.
func ExampleClient_DescribeFileSystemsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := efs.New(cfg)
	input := &efs.DescribeFileSystemsInput{}

	req := svc.DescribeFileSystemsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case efs.ErrCodeBadRequest:
				fmt.Println(efs.ErrCodeBadRequest, aerr.Error())
			case efs.ErrCodeInternalServerError:
				fmt.Println(efs.ErrCodeInternalServerError, aerr.Error())
			case efs.ErrCodeFileSystemNotFound:
				fmt.Println(efs.ErrCodeFileSystemNotFound, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the lifecycle configuration for a file system
//
// This operation describes a file system's LifecycleConfiguration. EFS lifecycle management
// uses the LifecycleConfiguration object to identify which files to move to the EFS
// Infrequent Access (IA) storage class.
func ExampleClient_DescribeLifecycleConfigurationRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := efs.New(cfg)
	input := &efs.DescribeLifecycleConfigurationInput{
		FileSystemId: aws.String("fs-01234567"),
	}

	req := svc.DescribeLifecycleConfigurationRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case efs.ErrCodeInternalServerError:
				fmt.Println(efs.ErrCodeInternalServerError, aerr.Error())
			case efs.ErrCodeBadRequest:
				fmt.Println(efs.ErrCodeBadRequest, aerr.Error())
			case efs.ErrCodeFileSystemNotFound:
				fmt.Println(efs.ErrCodeFileSystemNotFound, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the security groups for a mount target
//
// This operation describes all of the security groups for a file system's mount target.
func ExampleClient_DescribeMountTargetSecurityGroupsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := efs.New(cfg)
	input := &efs.DescribeMountTargetSecurityGroupsInput{
		MountTargetId: aws.String("fsmt-12340abc"),
	}

	req := svc.DescribeMountTargetSecurityGroupsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case efs.ErrCodeBadRequest:
				fmt.Println(efs.ErrCodeBadRequest, aerr.Error())
			case efs.ErrCodeInternalServerError:
				fmt.Println(efs.ErrCodeInternalServerError, aerr.Error())
			case efs.ErrCodeMountTargetNotFound:
				fmt.Println(efs.ErrCodeMountTargetNotFound, aerr.Error())
			case efs.ErrCodeIncorrectMountTargetState:
				fmt.Println(efs.ErrCodeIncorrectMountTargetState, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the mount targets for a file system
//
// This operation describes all of a file system's mount targets.
func ExampleClient_DescribeMountTargetsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := efs.New(cfg)
	input := &efs.DescribeMountTargetsInput{
		FileSystemId: aws.String("fs-01234567"),
	}

	req := svc.DescribeMountTargetsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case efs.ErrCodeBadRequest:
				fmt.Println(efs.ErrCodeBadRequest, aerr.Error())
			case efs.ErrCodeInternalServerError:
				fmt.Println(efs.ErrCodeInternalServerError, aerr.Error())
			case efs.ErrCodeFileSystemNotFound:
				fmt.Println(efs.ErrCodeFileSystemNotFound, aerr.Error())
			case efs.ErrCodeMountTargetNotFound:
				fmt.Println(efs.ErrCodeMountTargetNotFound, aerr.Error())
			case efs.ErrCodeAccessPointNotFound:
				fmt.Println(efs.ErrCodeAccessPointNotFound, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the tags for a file system
//
// This operation describes all of a file system's tags.
func ExampleClient_DescribeTagsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := efs.New(cfg)
	input := &efs.DescribeTagsInput{
		FileSystemId: aws.String("fs-01234567"),
	}

	req := svc.DescribeTagsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case efs.ErrCodeBadRequest:
				fmt.Println(efs.ErrCodeBadRequest, aerr.Error())
			case efs.ErrCodeInternalServerError:
				fmt.Println(efs.ErrCodeInternalServerError, aerr.Error())
			case efs.ErrCodeFileSystemNotFound:
				fmt.Println(efs.ErrCodeFileSystemNotFound, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the security groups associated with a mount target for a file system
//
// This operation modifies the security groups associated with a mount target for a
// file system.
func ExampleClient_ModifyMountTargetSecurityGroupsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := efs.New(cfg)
	input := &efs.ModifyMountTargetSecurityGroupsInput{
		MountTargetId: aws.String("fsmt-12340abc"),
		SecurityGroups: []string{
			"sg-abcd1234",
		},
	}

	req := svc.ModifyMountTargetSecurityGroupsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case efs.ErrCodeBadRequest:
				fmt.Println(efs.ErrCodeBadRequest, aerr.Error())
			case efs.ErrCodeInternalServerError:
				fmt.Println(efs.ErrCodeInternalServerError, aerr.Error())
			case efs.ErrCodeMountTargetNotFound:
				fmt.Println(efs.ErrCodeMountTargetNotFound, aerr.Error())
			case efs.ErrCodeIncorrectMountTargetState:
				fmt.Println(efs.ErrCodeIncorrectMountTargetState, aerr.Error())
			case efs.ErrCodeSecurityGroupLimitExceeded:
				fmt.Println(efs.ErrCodeSecurityGroupLimitExceeded, aerr.Error())
			case efs.ErrCodeSecurityGroupNotFound:
				fmt.Println(efs.ErrCodeSecurityGroupNotFound, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Creates a new lifecycleconfiguration object for a file system
//
// This operation enables lifecycle management on a file system by creating a new LifecycleConfiguration
// object. A LifecycleConfiguration object defines when files in an Amazon EFS file
// system are automatically transitioned to the lower-cost EFS Infrequent Access (IA)
// storage class. A LifecycleConfiguration applies to all files in a file system.
func ExampleClient_PutLifecycleConfigurationRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := efs.New(cfg)
	input := &efs.PutLifecycleConfigurationInput{
		FileSystemId: aws.String("fs-01234567"),
		LifecyclePolicies: []efs.LifecyclePolicy{
			{
				TransitionToIA: efs.TransitionToIARulesAfter30Days,
			},
		},
	}

	req := svc.PutLifecycleConfigurationRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case efs.ErrCodeBadRequest:
				fmt.Println(efs.ErrCodeBadRequest, aerr.Error())
			case efs.ErrCodeInternalServerError:
				fmt.Println(efs.ErrCodeInternalServerError, aerr.Error())
			case efs.ErrCodeFileSystemNotFound:
				fmt.Println(efs.ErrCodeFileSystemNotFound, aerr.Error())
			case efs.ErrCodeIncorrectFileSystemLifeCycleState:
				fmt.Println(efs.ErrCodeIncorrectFileSystemLifeCycleState, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
