// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package eks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteFargateProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EKS cluster associated with the Fargate profile to
	// delete.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the Fargate profile to delete.
	//
	// FargateProfileName is a required field
	FargateProfileName *string `location:"uri" locationName:"fargateProfileName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFargateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFargateProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFargateProfileInput"}

	if s.ClusterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterName"))
	}

	if s.FargateProfileName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FargateProfileName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFargateProfileInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ClusterName != nil {
		v := *s.ClusterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FargateProfileName != nil {
		v := *s.FargateProfileName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "fargateProfileName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteFargateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The deleted Fargate profile.
	FargateProfile *FargateProfile `locationName:"fargateProfile" type:"structure"`
}

// String returns the string representation
func (s DeleteFargateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFargateProfileOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.FargateProfile != nil {
		v := s.FargateProfile

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "fargateProfile", v, metadata)
	}
	return nil
}

const opDeleteFargateProfile = "DeleteFargateProfile"

// DeleteFargateProfileRequest returns a request value for making API operation for
// Amazon Elastic Kubernetes Service.
//
// Deletes an AWS Fargate profile.
//
// When you delete a Fargate profile, any pods running on Fargate that were
// created with the profile are deleted. If those pods match another Fargate
// profile, then they are scheduled on Fargate with that profile. If they no
// longer match any Fargate profiles, then they are not scheduled on Fargate
// and they may remain in a pending state.
//
// Only one Fargate profile in a cluster can be in the DELETING status at a
// time. You must wait for a Fargate profile to finish deleting before you can
// delete any other profiles in that cluster.
//
//    // Example sending a request using DeleteFargateProfileRequest.
//    req := client.DeleteFargateProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteFargateProfile
func (c *Client) DeleteFargateProfileRequest(input *DeleteFargateProfileInput) DeleteFargateProfileRequest {
	op := &aws.Operation{
		Name:       opDeleteFargateProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/clusters/{name}/fargate-profiles/{fargateProfileName}",
	}

	if input == nil {
		input = &DeleteFargateProfileInput{}
	}

	req := c.newRequest(op, input, &DeleteFargateProfileOutput{})

	return DeleteFargateProfileRequest{Request: req, Input: input, Copy: c.DeleteFargateProfileRequest}
}

// DeleteFargateProfileRequest is the request type for the
// DeleteFargateProfile API operation.
type DeleteFargateProfileRequest struct {
	*aws.Request
	Input *DeleteFargateProfileInput
	Copy  func(*DeleteFargateProfileInput) DeleteFargateProfileRequest
}

// Send marshals and sends the DeleteFargateProfile API request.
func (r DeleteFargateProfileRequest) Send(ctx context.Context) (*DeleteFargateProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteFargateProfileResponse{
		DeleteFargateProfileOutput: r.Request.Data.(*DeleteFargateProfileOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteFargateProfileResponse is the response type for the
// DeleteFargateProfile API operation.
type DeleteFargateProfileResponse struct {
	*DeleteFargateProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteFargateProfile request.
func (r *DeleteFargateProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
