// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"context"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Request to create a configuration template.
type CreateConfigurationTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the Elastic Beanstalk application to associate with this configuration
	// template.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// An optional description for this configuration.
	Description *string `type:"string"`

	// The ID of an environment whose settings you want to use to create the configuration
	// template. You must specify EnvironmentId if you don't specify PlatformArn,
	// SolutionStackName, or SourceConfiguration.
	EnvironmentId *string `type:"string"`

	// Option values for the Elastic Beanstalk configuration, such as the instance
	// type. If specified, these values override the values obtained from the solution
	// stack or the source configuration template. For a complete list of Elastic
	// Beanstalk configuration options, see Option Values (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html)
	// in the AWS Elastic Beanstalk Developer Guide.
	OptionSettings []ConfigurationOptionSetting `type:"list"`

	// The Amazon Resource Name (ARN) of the custom platform. For more information,
	// see Custom Platforms (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html)
	// in the AWS Elastic Beanstalk Developer Guide.
	//
	// If you specify PlatformArn, then don't specify SolutionStackName.
	PlatformArn *string `type:"string"`

	// The name of an Elastic Beanstalk solution stack (platform version) that this
	// configuration uses. For example, 64bit Amazon Linux 2013.09 running Tomcat
	// 7 Java 7. A solution stack specifies the operating system, runtime, and application
	// server for a configuration template. It also determines the set of configuration
	// options as well as the possible and default values. For more information,
	// see Supported Platforms (https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html)
	// in the AWS Elastic Beanstalk Developer Guide.
	//
	// You must specify SolutionStackName if you don't specify PlatformArn, EnvironmentId,
	// or SourceConfiguration.
	//
	// Use the ListAvailableSolutionStacks (https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListAvailableSolutionStacks.html)
	// API to obtain a list of available solution stacks.
	SolutionStackName *string `type:"string"`

	// An Elastic Beanstalk configuration template to base this one on. If specified,
	// Elastic Beanstalk uses the configuration values from the specified configuration
	// template to create a new configuration.
	//
	// Values specified in OptionSettings override any values obtained from the
	// SourceConfiguration.
	//
	// You must specify SourceConfiguration if you don't specify PlatformArn, EnvironmentId,
	// or SolutionStackName.
	//
	// Constraint: If both solution stack name and source configuration are specified,
	// the solution stack of the source configuration template must match the specified
	// solution stack name.
	SourceConfiguration *SourceConfiguration `type:"structure"`

	// Specifies the tags applied to the configuration template.
	Tags []Tag `type:"list"`

	// The name of the configuration template.
	//
	// Constraint: This name must be unique per application.
	//
	// TemplateName is a required field
	TemplateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateConfigurationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateConfigurationTemplateInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateName", 1))
	}
	if s.OptionSettings != nil {
		for i, v := range s.OptionSettings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OptionSettings", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SourceConfiguration != nil {
		if err := s.SourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SourceConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the settings for a configuration set.
type CreateConfigurationTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The name of the application associated with this configuration set.
	ApplicationName *string `min:"1" type:"string"`

	// The date (in UTC time) when this configuration set was created.
	DateCreated *time.Time `type:"timestamp"`

	// The date (in UTC time) when this configuration set was last modified.
	DateUpdated *time.Time `type:"timestamp"`

	// If this configuration set is associated with an environment, the DeploymentStatus
	// parameter indicates the deployment status of this configuration set:
	//
	//    * null: This configuration is not associated with a running environment.
	//
	//    * pending: This is a draft configuration that is not deployed to the associated
	//    environment but is in the process of deploying.
	//
	//    * deployed: This is the configuration that is currently deployed to the
	//    associated running environment.
	//
	//    * failed: This is a draft configuration that failed to successfully deploy.
	DeploymentStatus ConfigurationDeploymentStatus `type:"string" enum:"true"`

	// Describes this configuration set.
	Description *string `type:"string"`

	// If not null, the name of the environment for this configuration set.
	EnvironmentName *string `min:"4" type:"string"`

	// A list of the configuration options and their values in this configuration
	// set.
	OptionSettings []ConfigurationOptionSetting `type:"list"`

	// The ARN of the platform version.
	PlatformArn *string `type:"string"`

	// The name of the solution stack this configuration set uses.
	SolutionStackName *string `type:"string"`

	// If not null, the name of the configuration template for this configuration
	// set.
	TemplateName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateConfigurationTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateConfigurationTemplate = "CreateConfigurationTemplate"

// CreateConfigurationTemplateRequest returns a request value for making API operation for
// AWS Elastic Beanstalk.
//
// Creates an AWS Elastic Beanstalk configuration template, associated with
// a specific Elastic Beanstalk application. You define application configuration
// settings in a configuration template. You can then use the configuration
// template to deploy different versions of the application with the same configuration
// settings.
//
// Templates aren't associated with any environment. The EnvironmentName response
// element is always null.
//
// Related Topics
//
//    * DescribeConfigurationOptions
//
//    * DescribeConfigurationSettings
//
//    * ListAvailableSolutionStacks
//
//    // Example sending a request using CreateConfigurationTemplateRequest.
//    req := client.CreateConfigurationTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateConfigurationTemplate
func (c *Client) CreateConfigurationTemplateRequest(input *CreateConfigurationTemplateInput) CreateConfigurationTemplateRequest {
	op := &aws.Operation{
		Name:       opCreateConfigurationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConfigurationTemplateInput{}
	}

	req := c.newRequest(op, input, &CreateConfigurationTemplateOutput{})

	return CreateConfigurationTemplateRequest{Request: req, Input: input, Copy: c.CreateConfigurationTemplateRequest}
}

// CreateConfigurationTemplateRequest is the request type for the
// CreateConfigurationTemplate API operation.
type CreateConfigurationTemplateRequest struct {
	*aws.Request
	Input *CreateConfigurationTemplateInput
	Copy  func(*CreateConfigurationTemplateInput) CreateConfigurationTemplateRequest
}

// Send marshals and sends the CreateConfigurationTemplate API request.
func (r CreateConfigurationTemplateRequest) Send(ctx context.Context) (*CreateConfigurationTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateConfigurationTemplateResponse{
		CreateConfigurationTemplateOutput: r.Request.Data.(*CreateConfigurationTemplateOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateConfigurationTemplateResponse is the response type for the
// CreateConfigurationTemplate API operation.
type CreateConfigurationTemplateResponse struct {
	*CreateConfigurationTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateConfigurationTemplate request.
func (r *CreateConfigurationTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
