// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancing

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for ApplySecurityGroupsToLoadBalancer.
type ApplySecurityGroupsToLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `type:"string" required:"true"`

	// The IDs of the security groups to associate with the load balancer. Note
	// that you cannot specify the name of the security group.
	//
	// SecurityGroups is a required field
	SecurityGroups []string `type:"list" required:"true"`
}

// String returns the string representation
func (s ApplySecurityGroupsToLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplySecurityGroupsToLoadBalancerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ApplySecurityGroupsToLoadBalancerInput"}

	if s.LoadBalancerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LoadBalancerName"))
	}

	if s.SecurityGroups == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecurityGroups"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of ApplySecurityGroupsToLoadBalancer.
type ApplySecurityGroupsToLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// The IDs of the security groups associated with the load balancer.
	SecurityGroups []string `type:"list"`
}

// String returns the string representation
func (s ApplySecurityGroupsToLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

const opApplySecurityGroupsToLoadBalancer = "ApplySecurityGroupsToLoadBalancer"

// ApplySecurityGroupsToLoadBalancerRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Associates one or more security groups with your load balancer in a virtual
// private cloud (VPC). The specified security groups override the previously
// associated security groups.
//
// For more information, see Security Groups for Load Balancers in a VPC (http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-security-groups.html#elb-vpc-security-groups)
// in the Classic Load Balancers Guide.
//
//    // Example sending a request using ApplySecurityGroupsToLoadBalancerRequest.
//    req := client.ApplySecurityGroupsToLoadBalancerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/ApplySecurityGroupsToLoadBalancer
func (c *Client) ApplySecurityGroupsToLoadBalancerRequest(input *ApplySecurityGroupsToLoadBalancerInput) ApplySecurityGroupsToLoadBalancerRequest {
	op := &aws.Operation{
		Name:       opApplySecurityGroupsToLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ApplySecurityGroupsToLoadBalancerInput{}
	}

	req := c.newRequest(op, input, &ApplySecurityGroupsToLoadBalancerOutput{})

	return ApplySecurityGroupsToLoadBalancerRequest{Request: req, Input: input, Copy: c.ApplySecurityGroupsToLoadBalancerRequest}
}

// ApplySecurityGroupsToLoadBalancerRequest is the request type for the
// ApplySecurityGroupsToLoadBalancer API operation.
type ApplySecurityGroupsToLoadBalancerRequest struct {
	*aws.Request
	Input *ApplySecurityGroupsToLoadBalancerInput
	Copy  func(*ApplySecurityGroupsToLoadBalancerInput) ApplySecurityGroupsToLoadBalancerRequest
}

// Send marshals and sends the ApplySecurityGroupsToLoadBalancer API request.
func (r ApplySecurityGroupsToLoadBalancerRequest) Send(ctx context.Context) (*ApplySecurityGroupsToLoadBalancerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ApplySecurityGroupsToLoadBalancerResponse{
		ApplySecurityGroupsToLoadBalancerOutput: r.Request.Data.(*ApplySecurityGroupsToLoadBalancerOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ApplySecurityGroupsToLoadBalancerResponse is the response type for the
// ApplySecurityGroupsToLoadBalancer API operation.
type ApplySecurityGroupsToLoadBalancerResponse struct {
	*ApplySecurityGroupsToLoadBalancerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ApplySecurityGroupsToLoadBalancer request.
func (r *ApplySecurityGroupsToLoadBalancerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
