// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancingv2

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type SetRulePrioritiesInput struct {
	_ struct{} `type:"structure"`

	// The rule priorities.
	//
	// RulePriorities is a required field
	RulePriorities []RulePriorityPair `type:"list" required:"true"`
}

// String returns the string representation
func (s SetRulePrioritiesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetRulePrioritiesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetRulePrioritiesInput"}

	if s.RulePriorities == nil {
		invalidParams.Add(aws.NewErrParamRequired("RulePriorities"))
	}
	if s.RulePriorities != nil {
		for i, v := range s.RulePriorities {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RulePriorities", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetRulePrioritiesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the rules.
	Rules []Rule `type:"list"`
}

// String returns the string representation
func (s SetRulePrioritiesOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetRulePriorities = "SetRulePriorities"

// SetRulePrioritiesRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Sets the priorities of the specified rules.
//
// You can reorder the rules as long as there are no priority conflicts in the
// new order. Any existing rules that you do not specify retain their current
// priority.
//
//    // Example sending a request using SetRulePrioritiesRequest.
//    req := client.SetRulePrioritiesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetRulePriorities
func (c *Client) SetRulePrioritiesRequest(input *SetRulePrioritiesInput) SetRulePrioritiesRequest {
	op := &aws.Operation{
		Name:       opSetRulePriorities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetRulePrioritiesInput{}
	}

	req := c.newRequest(op, input, &SetRulePrioritiesOutput{})

	return SetRulePrioritiesRequest{Request: req, Input: input, Copy: c.SetRulePrioritiesRequest}
}

// SetRulePrioritiesRequest is the request type for the
// SetRulePriorities API operation.
type SetRulePrioritiesRequest struct {
	*aws.Request
	Input *SetRulePrioritiesInput
	Copy  func(*SetRulePrioritiesInput) SetRulePrioritiesRequest
}

// Send marshals and sends the SetRulePriorities API request.
func (r SetRulePrioritiesRequest) Send(ctx context.Context) (*SetRulePrioritiesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetRulePrioritiesResponse{
		SetRulePrioritiesOutput: r.Request.Data.(*SetRulePrioritiesOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetRulePrioritiesResponse is the response type for the
// SetRulePriorities API operation.
type SetRulePrioritiesResponse struct {
	*SetRulePrioritiesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetRulePriorities request.
func (r *SetRulePrioritiesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
