// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elastictranscoder

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The CreatePresetRequest structure.
type CreatePresetInput struct {
	_ struct{} `type:"structure"`

	// A section of the request body that specifies the audio parameters.
	Audio *AudioParameters `type:"structure"`

	// The container type for the output file. Valid values include flac, flv, fmp4,
	// gif, mp3, mp4, mpg, mxf, oga, ogg, ts, and webm.
	//
	// Container is a required field
	Container *string `type:"string" required:"true"`

	// A description of the preset.
	Description *string `type:"string"`

	// The name of the preset. We recommend that the name be unique within the AWS
	// account, but uniqueness is not enforced.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A section of the request body that specifies the thumbnail parameters, if
	// any.
	Thumbnails *Thumbnails `type:"structure"`

	// A section of the request body that specifies the video parameters.
	Video *VideoParameters `type:"structure"`
}

// String returns the string representation
func (s CreatePresetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePresetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreatePresetInput"}

	if s.Container == nil {
		invalidParams.Add(aws.NewErrParamRequired("Container"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Video != nil {
		if err := s.Video.Validate(); err != nil {
			invalidParams.AddNested("Video", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreatePresetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Audio != nil {
		v := s.Audio

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Audio", v, metadata)
	}
	if s.Container != nil {
		v := *s.Container

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Container", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Thumbnails != nil {
		v := s.Thumbnails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Thumbnails", v, metadata)
	}
	if s.Video != nil {
		v := s.Video

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Video", v, metadata)
	}
	return nil
}

// The CreatePresetResponse structure.
type CreatePresetOutput struct {
	_ struct{} `type:"structure"`

	// A section of the response body that provides information about the preset
	// that is created.
	Preset *Preset `type:"structure"`

	// If the preset settings don't comply with the standards for the video codec
	// but Elastic Transcoder created the preset, this message explains the reason
	// the preset settings don't meet the standard. Elastic Transcoder created the
	// preset because the settings might produce acceptable output.
	Warning *string `type:"string"`
}

// String returns the string representation
func (s CreatePresetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreatePresetOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Preset != nil {
		v := s.Preset

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Preset", v, metadata)
	}
	if s.Warning != nil {
		v := *s.Warning

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Warning", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreatePreset = "CreatePreset"

// CreatePresetRequest returns a request value for making API operation for
// Amazon Elastic Transcoder.
//
// The CreatePreset operation creates a preset with settings that you specify.
//
// Elastic Transcoder checks the CreatePreset settings to ensure that they meet
// Elastic Transcoder requirements and to determine whether they comply with
// H.264 standards. If your settings are not valid for Elastic Transcoder, Elastic
// Transcoder returns an HTTP 400 response (ValidationException) and does not
// create the preset. If the settings are valid for Elastic Transcoder but aren't
// strictly compliant with the H.264 standard, Elastic Transcoder creates the
// preset and returns a warning message in the response. This helps you determine
// whether your settings comply with the H.264 standard while giving you greater
// flexibility with respect to the video that Elastic Transcoder produces.
//
// Elastic Transcoder uses the H.264 video-compression format. For more information,
// see the International Telecommunication Union publication Recommendation
// ITU-T H.264: Advanced video coding for generic audiovisual services.
//
//    // Example sending a request using CreatePresetRequest.
//    req := client.CreatePresetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) CreatePresetRequest(input *CreatePresetInput) CreatePresetRequest {
	op := &aws.Operation{
		Name:       opCreatePreset,
		HTTPMethod: "POST",
		HTTPPath:   "/2012-09-25/presets",
	}

	if input == nil {
		input = &CreatePresetInput{}
	}

	req := c.newRequest(op, input, &CreatePresetOutput{})

	return CreatePresetRequest{Request: req, Input: input, Copy: c.CreatePresetRequest}
}

// CreatePresetRequest is the request type for the
// CreatePreset API operation.
type CreatePresetRequest struct {
	*aws.Request
	Input *CreatePresetInput
	Copy  func(*CreatePresetInput) CreatePresetRequest
}

// Send marshals and sends the CreatePreset API request.
func (r CreatePresetRequest) Send(ctx context.Context) (*CreatePresetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreatePresetResponse{
		CreatePresetOutput: r.Request.Data.(*CreatePresetOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreatePresetResponse is the response type for the
// CreatePreset API operation.
type CreatePresetResponse struct {
	*CreatePresetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreatePreset request.
func (r *CreatePresetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
