// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package eventbridge

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeactivateEventSourceInput struct {
	_ struct{} `type:"structure"`

	// The name of the partner event source to deactivate.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeactivateEventSourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeactivateEventSourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeactivateEventSourceInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeactivateEventSourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeactivateEventSourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeactivateEventSource = "DeactivateEventSource"

// DeactivateEventSourceRequest returns a request value for making API operation for
// Amazon EventBridge.
//
// You can use this operation to temporarily stop receiving events from the
// specified partner event source. The matching event bus is not deleted.
//
// When you deactivate a partner event source, the source goes into PENDING
// state. If it remains in PENDING state for more than two weeks, it is deleted.
//
// To activate a deactivated partner event source, use ActivateEventSource.
//
//    // Example sending a request using DeactivateEventSourceRequest.
//    req := client.DeactivateEventSourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/DeactivateEventSource
func (c *Client) DeactivateEventSourceRequest(input *DeactivateEventSourceInput) DeactivateEventSourceRequest {
	op := &aws.Operation{
		Name:       opDeactivateEventSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeactivateEventSourceInput{}
	}

	req := c.newRequest(op, input, &DeactivateEventSourceOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeactivateEventSourceRequest{Request: req, Input: input, Copy: c.DeactivateEventSourceRequest}
}

// DeactivateEventSourceRequest is the request type for the
// DeactivateEventSource API operation.
type DeactivateEventSourceRequest struct {
	*aws.Request
	Input *DeactivateEventSourceInput
	Copy  func(*DeactivateEventSourceInput) DeactivateEventSourceRequest
}

// Send marshals and sends the DeactivateEventSource API request.
func (r DeactivateEventSourceRequest) Send(ctx context.Context) (*DeactivateEventSourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeactivateEventSourceResponse{
		DeactivateEventSourceOutput: r.Request.Data.(*DeactivateEventSourceOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeactivateEventSourceResponse is the response type for the
// DeactivateEventSource API operation.
type DeactivateEventSourceResponse struct {
	*DeactivateEventSourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeactivateEventSource request.
func (r *DeactivateEventSourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
