// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DisassociateAdminAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

type DisassociateAdminAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateAdminAccount = "DisassociateAdminAccount"

// DisassociateAdminAccountRequest returns a request value for making API operation for
// Firewall Management Service.
//
// Disassociates the account that has been set as the AWS Firewall Manager administrator
// account. To set a different account as the administrator account, you must
// submit an AssociateAdminAccount request.
//
//    // Example sending a request using DisassociateAdminAccountRequest.
//    req := client.DisassociateAdminAccountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DisassociateAdminAccount
func (c *Client) DisassociateAdminAccountRequest(input *DisassociateAdminAccountInput) DisassociateAdminAccountRequest {
	op := &aws.Operation{
		Name:       opDisassociateAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateAdminAccountInput{}
	}

	req := c.newRequest(op, input, &DisassociateAdminAccountOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DisassociateAdminAccountRequest{Request: req, Input: input, Copy: c.DisassociateAdminAccountRequest}
}

// DisassociateAdminAccountRequest is the request type for the
// DisassociateAdminAccount API operation.
type DisassociateAdminAccountRequest struct {
	*aws.Request
	Input *DisassociateAdminAccountInput
	Copy  func(*DisassociateAdminAccountInput) DisassociateAdminAccountRequest
}

// Send marshals and sends the DisassociateAdminAccount API request.
func (r DisassociateAdminAccountRequest) Send(ctx context.Context) (*DisassociateAdminAccountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateAdminAccountResponse{
		DisassociateAdminAccountOutput: r.Request.Data.(*DisassociateAdminAccountOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateAdminAccountResponse is the response type for the
// DisassociateAdminAccount API operation.
type DisassociateAdminAccountResponse struct {
	*DisassociateAdminAccountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateAdminAccount request.
func (r *DisassociateAdminAccountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
