// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetEntityTypesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	// The name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The next token for the subsequent request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetEntityTypesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEntityTypesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetEntityTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetEntityTypesOutput struct {
	_ struct{} `type:"structure"`

	// An array of entity types.
	EntityTypes []EntityType `locationName:"entityTypes" type:"list"`

	// The next page token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetEntityTypesOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetEntityTypes = "GetEntityTypes"

// GetEntityTypesRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Gets all entity types or a specific entity type if a name is specified. This
// is a paginated API. If you provide a null maxResults, this action retrieves
// a maximum of 10 records per page. If you provide a maxResults, the value
// must be between 5 and 10. To get the next page results, provide the pagination
// token from the GetEntityTypesResponse as part of your request. A null pagination
// token fetches the records from the beginning.
//
//    // Example sending a request using GetEntityTypesRequest.
//    req := client.GetEntityTypesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEntityTypes
func (c *Client) GetEntityTypesRequest(input *GetEntityTypesInput) GetEntityTypesRequest {
	op := &aws.Operation{
		Name:       opGetEntityTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetEntityTypesInput{}
	}

	req := c.newRequest(op, input, &GetEntityTypesOutput{})

	return GetEntityTypesRequest{Request: req, Input: input, Copy: c.GetEntityTypesRequest}
}

// GetEntityTypesRequest is the request type for the
// GetEntityTypes API operation.
type GetEntityTypesRequest struct {
	*aws.Request
	Input *GetEntityTypesInput
	Copy  func(*GetEntityTypesInput) GetEntityTypesRequest
}

// Send marshals and sends the GetEntityTypes API request.
func (r GetEntityTypesRequest) Send(ctx context.Context) (*GetEntityTypesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetEntityTypesResponse{
		GetEntityTypesOutput: r.Request.Data.(*GetEntityTypesOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetEntityTypesRequestPaginator returns a paginator for GetEntityTypes.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetEntityTypesRequest(input)
//   p := frauddetector.NewGetEntityTypesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetEntityTypesPaginator(req GetEntityTypesRequest) GetEntityTypesPaginator {
	return GetEntityTypesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetEntityTypesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetEntityTypesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetEntityTypesPaginator struct {
	aws.Pager
}

func (p *GetEntityTypesPaginator) CurrentPage() *GetEntityTypesOutput {
	return p.Pager.CurrentPage().(*GetEntityTypesOutput)
}

// GetEntityTypesResponse is the response type for the
// GetEntityTypes API operation.
type GetEntityTypesResponse struct {
	*GetEntityTypesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetEntityTypes request.
func (r *GetEntityTypesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
