// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetKMSEncryptionKeyInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetKMSEncryptionKeyInput) String() string {
	return awsutil.Prettify(s)
}

type GetKMSEncryptionKeyOutput struct {
	_ struct{} `type:"structure"`

	// The KMS encryption key.
	KmsKey *KMSKey `locationName:"kmsKey" type:"structure"`
}

// String returns the string representation
func (s GetKMSEncryptionKeyOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetKMSEncryptionKey = "GetKMSEncryptionKey"

// GetKMSEncryptionKeyRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Gets the encryption key if a Key Management Service (KMS) customer master
// key (CMK) has been specified to be used to encrypt content in Amazon Fraud
// Detector.
//
//    // Example sending a request using GetKMSEncryptionKeyRequest.
//    req := client.GetKMSEncryptionKeyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetKMSEncryptionKey
func (c *Client) GetKMSEncryptionKeyRequest(input *GetKMSEncryptionKeyInput) GetKMSEncryptionKeyRequest {
	op := &aws.Operation{
		Name:       opGetKMSEncryptionKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKMSEncryptionKeyInput{}
	}

	req := c.newRequest(op, input, &GetKMSEncryptionKeyOutput{})

	return GetKMSEncryptionKeyRequest{Request: req, Input: input, Copy: c.GetKMSEncryptionKeyRequest}
}

// GetKMSEncryptionKeyRequest is the request type for the
// GetKMSEncryptionKey API operation.
type GetKMSEncryptionKeyRequest struct {
	*aws.Request
	Input *GetKMSEncryptionKeyInput
	Copy  func(*GetKMSEncryptionKeyInput) GetKMSEncryptionKeyRequest
}

// Send marshals and sends the GetKMSEncryptionKey API request.
func (r GetKMSEncryptionKeyRequest) Send(ctx context.Context) (*GetKMSEncryptionKeyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetKMSEncryptionKeyResponse{
		GetKMSEncryptionKeyOutput: r.Request.Data.(*GetKMSEncryptionKeyOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetKMSEncryptionKeyResponse is the response type for the
// GetKMSEncryptionKey API operation.
type GetKMSEncryptionKeyResponse struct {
	*GetKMSEncryptionKeyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetKMSEncryptionKey request.
func (r *GetKMSEncryptionKeyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
