// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateDetectorVersionMetadataInput struct {
	_ struct{} `type:"structure"`

	// The description.
	//
	// Description is a required field
	Description *string `locationName:"description" min:"1" type:"string" required:"true"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The detector version ID.
	//
	// DetectorVersionId is a required field
	DetectorVersionId *string `locationName:"detectorVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDetectorVersionMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDetectorVersionMetadataInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDetectorVersionMetadataInput"}

	if s.Description == nil {
		invalidParams.Add(aws.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DetectorId", 1))
	}

	if s.DetectorVersionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorVersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateDetectorVersionMetadataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDetectorVersionMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateDetectorVersionMetadata = "UpdateDetectorVersionMetadata"

// UpdateDetectorVersionMetadataRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Updates the detector version's description. You can update the metadata for
// any detector version (DRAFT, ACTIVE, or INACTIVE).
//
//    // Example sending a request using UpdateDetectorVersionMetadataRequest.
//    req := client.UpdateDetectorVersionMetadataRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionMetadata
func (c *Client) UpdateDetectorVersionMetadataRequest(input *UpdateDetectorVersionMetadataInput) UpdateDetectorVersionMetadataRequest {
	op := &aws.Operation{
		Name:       opUpdateDetectorVersionMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDetectorVersionMetadataInput{}
	}

	req := c.newRequest(op, input, &UpdateDetectorVersionMetadataOutput{})

	return UpdateDetectorVersionMetadataRequest{Request: req, Input: input, Copy: c.UpdateDetectorVersionMetadataRequest}
}

// UpdateDetectorVersionMetadataRequest is the request type for the
// UpdateDetectorVersionMetadata API operation.
type UpdateDetectorVersionMetadataRequest struct {
	*aws.Request
	Input *UpdateDetectorVersionMetadataInput
	Copy  func(*UpdateDetectorVersionMetadataInput) UpdateDetectorVersionMetadataRequest
}

// Send marshals and sends the UpdateDetectorVersionMetadata API request.
func (r UpdateDetectorVersionMetadataRequest) Send(ctx context.Context) (*UpdateDetectorVersionMetadataResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDetectorVersionMetadataResponse{
		UpdateDetectorVersionMetadataOutput: r.Request.Data.(*UpdateDetectorVersionMetadataOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDetectorVersionMetadataResponse is the response type for the
// UpdateDetectorVersionMetadata API operation.
type UpdateDetectorVersionMetadataResponse struct {
	*UpdateDetectorVersionMetadataOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDetectorVersionMetadata request.
func (r *UpdateDetectorVersionMetadataResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
