// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fsx

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The request object for DeleteFileSystem operation.
type DeleteFileSystemInput struct {
	_ struct{} `type:"structure"`

	// A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent
	// deletion. This is automatically filled on your behalf when using the AWS
	// CLI or SDK.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the file system you want to delete.
	//
	// FileSystemId is a required field
	FileSystemId *string `min:"11" type:"string" required:"true"`

	// The configuration object for the Amazon FSx for Lustre file system being
	// deleted in the DeleteFileSystem operation.
	LustreConfiguration *DeleteFileSystemLustreConfiguration `type:"structure"`

	// The configuration object for the Microsoft Windows file system used in the
	// DeleteFileSystem operation.
	WindowsConfiguration *DeleteFileSystemWindowsConfiguration `type:"structure"`
}

// String returns the string representation
func (s DeleteFileSystemInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFileSystemInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFileSystemInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}

	if s.FileSystemId == nil {
		invalidParams.Add(aws.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 11 {
		invalidParams.Add(aws.NewErrParamMinLen("FileSystemId", 11))
	}
	if s.LustreConfiguration != nil {
		if err := s.LustreConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LustreConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.WindowsConfiguration != nil {
		if err := s.WindowsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("WindowsConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response object for the DeleteFileSystem operation.
type DeleteFileSystemOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the file system being deleted.
	FileSystemId *string `min:"11" type:"string"`

	// The file system lifecycle for the deletion request. Should be DELETING.
	Lifecycle FileSystemLifecycle `type:"string" enum:"true"`

	// The response object for the Amazon FSx for Lustre file system being deleted
	// in the DeleteFileSystem operation.
	LustreResponse *DeleteFileSystemLustreResponse `type:"structure"`

	// The response object for the Microsoft Windows file system used in the DeleteFileSystem
	// operation.
	WindowsResponse *DeleteFileSystemWindowsResponse `type:"structure"`
}

// String returns the string representation
func (s DeleteFileSystemOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteFileSystem = "DeleteFileSystem"

// DeleteFileSystemRequest returns a request value for making API operation for
// Amazon FSx.
//
// Deletes a file system, deleting its contents. After deletion, the file system
// no longer exists, and its data is gone. Any existing automatic backups will
// also be deleted.
//
// By default, when you delete an Amazon FSx for Windows File Server file system,
// a final backup is created upon deletion. This final backup is not subject
// to the file system's retention policy, and must be manually deleted.
//
// The DeleteFileSystem action returns while the file system has the DELETING
// status. You can check the file system deletion status by calling the DescribeFileSystems
// action, which returns a list of file systems in your account. If you pass
// the file system ID for a deleted file system, the DescribeFileSystems returns
// a FileSystemNotFound error.
//
// Deleting an Amazon FSx for Lustre file system will fail with a 400 BadRequest
// if a data repository task is in a PENDING or EXECUTING state.
//
// The data in a deleted file system is also deleted and can't be recovered
// by any means.
//
//    // Example sending a request using DeleteFileSystemRequest.
//    req := client.DeleteFileSystemRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DeleteFileSystem
func (c *Client) DeleteFileSystemRequest(input *DeleteFileSystemInput) DeleteFileSystemRequest {
	op := &aws.Operation{
		Name:       opDeleteFileSystem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFileSystemInput{}
	}

	req := c.newRequest(op, input, &DeleteFileSystemOutput{})

	return DeleteFileSystemRequest{Request: req, Input: input, Copy: c.DeleteFileSystemRequest}
}

// DeleteFileSystemRequest is the request type for the
// DeleteFileSystem API operation.
type DeleteFileSystemRequest struct {
	*aws.Request
	Input *DeleteFileSystemInput
	Copy  func(*DeleteFileSystemInput) DeleteFileSystemRequest
}

// Send marshals and sends the DeleteFileSystem API request.
func (r DeleteFileSystemRequest) Send(ctx context.Context) (*DeleteFileSystemResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteFileSystemResponse{
		DeleteFileSystemOutput: r.Request.Data.(*DeleteFileSystemOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteFileSystemResponse is the response type for the
// DeleteFileSystem API operation.
type DeleteFileSystemResponse struct {
	*DeleteFileSystemOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteFileSystem request.
func (r *DeleteFileSystemResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
