// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input for a request action.
type CreateBuildInput struct {
	_ struct{} `type:"structure"`

	// A descriptive label that is associated with a build. Build names do not need
	// to be unique. You can use UpdateBuild to change this value later.
	Name *string `min:"1" type:"string"`

	// The operating system that the game server binaries are built to run on. This
	// value determines the type of fleet resources that you can use for this build.
	// If your game build contains multiple executables, they all must run on the
	// same operating system. If an operating system is not specified when creating
	// a build, Amazon GameLift uses the default value (WINDOWS_2012). This value
	// cannot be changed later.
	OperatingSystem OperatingSystem `type:"string" enum:"true"`

	// Information indicating where your game build files are stored. Use this parameter
	// only when creating a build with files stored in an S3 bucket that you own.
	// The storage location must specify an S3 bucket name and key. The location
	// must also specify a role ARN that you set up to allow Amazon GameLift to
	// access your S3 bucket. The S3 bucket and your new build must be in the same
	// Region.
	StorageLocation *S3Location `type:"structure"`

	// A list of labels to assign to the new build resource. Tags are developer-defined
	// key-value pairs. Tagging AWS resources are useful for resource management,
	// access management and cost allocation. For more information, see Tagging
	// AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// in the AWS General Reference. Once the resource is created, you can use TagResource,
	// UntagResource, and ListTagsForResource to add, remove, and view tags. The
	// maximum tag limit may be lower than stated. See the AWS General Reference
	// for actual tagging limits.
	Tags []Tag `type:"list"`

	// Version information that is associated with a build or script. Version strings
	// do not need to be unique. You can use UpdateBuild to change this value later.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateBuildInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBuildInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateBuildInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Version", 1))
	}
	if s.StorageLocation != nil {
		if err := s.StorageLocation.Validate(); err != nil {
			invalidParams.AddNested("StorageLocation", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the returned data in response to a request action.
type CreateBuildOutput struct {
	_ struct{} `type:"structure"`

	// The newly created build resource, including a unique build IDs and status.
	Build *Build `type:"structure"`

	// Amazon S3 location for your game build file, including bucket name and key.
	StorageLocation *S3Location `type:"structure"`

	// This element is returned only when the operation is called without a storage
	// location. It contains credentials to use when you are uploading a build file
	// to an S3 bucket that is owned by Amazon GameLift. Credentials have a limited
	// life span. To refresh these credentials, call RequestUploadCredentials.
	UploadCredentials *AwsCredentials `type:"structure" sensitive:"true"`
}

// String returns the string representation
func (s CreateBuildOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateBuild = "CreateBuild"

// CreateBuildRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Creates a new Amazon GameLift build resource for your game server binary
// files. Game server binaries must be combined into a zip file for use with
// Amazon GameLift.
//
// When setting up a new game build for GameLift, we recommend using the AWS
// CLI command upload-build (https://docs.aws.amazon.com/cli/latest/reference/gamelift/upload-build.html)
// . This helper command combines two tasks: (1) it uploads your build files
// from a file directory to a GameLift Amazon S3 location, and (2) it creates
// a new build resource.
//
// The CreateBuild operation can used in the following scenarios:
//
//    * To create a new game build with build files that are in an S3 location
//    under an AWS account that you control. To use this option, you must first
//    give Amazon GameLift access to the S3 bucket. With permissions in place,
//    call CreateBuild and specify a build name, operating system, and the S3
//    storage location of your game build.
//
//    * To directly upload your build files to a GameLift S3 location. To use
//    this option, first call CreateBuild and specify a build name and operating
//    system. This action creates a new build resource and also returns an S3
//    location with temporary access credentials. Use the credentials to manually
//    upload your build files to the specified S3 location. For more information,
//    see Uploading Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/UploadingObjects.html)
//    in the Amazon S3 Developer Guide. Build files can be uploaded to the GameLift
//    S3 location once only; that can't be updated.
//
// If successful, this operation creates a new build resource with a unique
// build ID and places it in INITIALIZED status. A build must be in READY status
// before you can create fleets with it.
//
// Learn more
//
// Uploading Your Game (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html)
//
//  Create a Build with Files in Amazon S3 (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build)
//
// Related operations
//
//    * CreateBuild
//
//    * ListBuilds
//
//    * DescribeBuild
//
//    * UpdateBuild
//
//    * DeleteBuild
//
//    // Example sending a request using CreateBuildRequest.
//    req := client.CreateBuildRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateBuild
func (c *Client) CreateBuildRequest(input *CreateBuildInput) CreateBuildRequest {
	op := &aws.Operation{
		Name:       opCreateBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBuildInput{}
	}

	req := c.newRequest(op, input, &CreateBuildOutput{})

	return CreateBuildRequest{Request: req, Input: input, Copy: c.CreateBuildRequest}
}

// CreateBuildRequest is the request type for the
// CreateBuild API operation.
type CreateBuildRequest struct {
	*aws.Request
	Input *CreateBuildInput
	Copy  func(*CreateBuildInput) CreateBuildRequest
}

// Send marshals and sends the CreateBuild API request.
func (r CreateBuildRequest) Send(ctx context.Context) (*CreateBuildResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateBuildResponse{
		CreateBuildOutput: r.Request.Data.(*CreateBuildOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateBuildResponse is the response type for the
// CreateBuild API operation.
type CreateBuildResponse struct {
	*CreateBuildOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateBuild request.
func (r *CreateBuildResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
