// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteWorkflowInput struct {
	_ struct{} `type:"structure"`

	// Name of the workflow to be deleted.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkflowInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteWorkflowInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// Name of the workflow specified in input.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteWorkflow = "DeleteWorkflow"

// DeleteWorkflowRequest returns a request value for making API operation for
// AWS Glue.
//
// Deletes a workflow.
//
//    // Example sending a request using DeleteWorkflowRequest.
//    req := client.DeleteWorkflowRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteWorkflow
func (c *Client) DeleteWorkflowRequest(input *DeleteWorkflowInput) DeleteWorkflowRequest {
	op := &aws.Operation{
		Name:       opDeleteWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWorkflowInput{}
	}

	req := c.newRequest(op, input, &DeleteWorkflowOutput{})

	return DeleteWorkflowRequest{Request: req, Input: input, Copy: c.DeleteWorkflowRequest}
}

// DeleteWorkflowRequest is the request type for the
// DeleteWorkflow API operation.
type DeleteWorkflowRequest struct {
	*aws.Request
	Input *DeleteWorkflowInput
	Copy  func(*DeleteWorkflowInput) DeleteWorkflowRequest
}

// Send marshals and sends the DeleteWorkflow API request.
func (r DeleteWorkflowRequest) Send(ctx context.Context) (*DeleteWorkflowResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteWorkflowResponse{
		DeleteWorkflowOutput: r.Request.Data.(*DeleteWorkflowOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteWorkflowResponse is the response type for the
// DeleteWorkflow API operation.
type DeleteWorkflowResponse struct {
	*DeleteWorkflowOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteWorkflow request.
func (r *DeleteWorkflowResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
