// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetJobsInput struct {
	_ struct{} `type:"structure"`

	// The maximum size of the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is a continuation call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetJobsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of job definitions.
	Jobs []Job `type:"list"`

	// A continuation token, if not all job definitions have yet been returned.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetJobsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetJobs = "GetJobs"

// GetJobsRequest returns a request value for making API operation for
// AWS Glue.
//
// Retrieves all current job definitions.
//
//    // Example sending a request using GetJobsRequest.
//    req := client.GetJobsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobs
func (c *Client) GetJobsRequest(input *GetJobsInput) GetJobsRequest {
	op := &aws.Operation{
		Name:       opGetJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetJobsInput{}
	}

	req := c.newRequest(op, input, &GetJobsOutput{})

	return GetJobsRequest{Request: req, Input: input, Copy: c.GetJobsRequest}
}

// GetJobsRequest is the request type for the
// GetJobs API operation.
type GetJobsRequest struct {
	*aws.Request
	Input *GetJobsInput
	Copy  func(*GetJobsInput) GetJobsRequest
}

// Send marshals and sends the GetJobs API request.
func (r GetJobsRequest) Send(ctx context.Context) (*GetJobsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetJobsResponse{
		GetJobsOutput: r.Request.Data.(*GetJobsOutput),
		response:      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetJobsRequestPaginator returns a paginator for GetJobs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetJobsRequest(input)
//   p := glue.NewGetJobsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetJobsPaginator(req GetJobsRequest) GetJobsPaginator {
	return GetJobsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetJobsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetJobsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetJobsPaginator struct {
	aws.Pager
}

func (p *GetJobsPaginator) CurrentPage() *GetJobsOutput {
	return p.Pager.CurrentPage().(*GetJobsOutput)
}

// GetJobsResponse is the response type for the
// GetJobs API operation.
type GetJobsResponse struct {
	*GetJobsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetJobs request.
func (r *GetJobsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
