// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetMLTaskRunsInput struct {
	_ struct{} `type:"structure"`

	// The filter criteria, in the TaskRunFilterCriteria structure, for the task
	// run.
	Filter *TaskRunFilterCriteria `type:"structure"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token for pagination of the results. The default is empty.
	NextToken *string `type:"string"`

	// The sorting criteria, in the TaskRunSortCriteria structure, for the task
	// run.
	Sort *TaskRunSortCriteria `type:"structure"`

	// The unique identifier of the machine learning transform.
	//
	// TransformId is a required field
	TransformId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMLTaskRunsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMLTaskRunsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetMLTaskRunsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.TransformId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransformId"))
	}
	if s.TransformId != nil && len(*s.TransformId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TransformId", 1))
	}
	if s.Sort != nil {
		if err := s.Sort.Validate(); err != nil {
			invalidParams.AddNested("Sort", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetMLTaskRunsOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token, if more results are available.
	NextToken *string `type:"string"`

	// A list of task runs that are associated with the transform.
	TaskRuns []TaskRun `type:"list"`
}

// String returns the string representation
func (s GetMLTaskRunsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetMLTaskRuns = "GetMLTaskRuns"

// GetMLTaskRunsRequest returns a request value for making API operation for
// AWS Glue.
//
// Gets a list of runs for a machine learning transform. Machine learning task
// runs are asynchronous tasks that AWS Glue runs on your behalf as part of
// various machine learning workflows. You can get a sortable, filterable list
// of machine learning task runs by calling GetMLTaskRuns with their parent
// transform's TransformID and other optional parameters as documented in this
// section.
//
// This operation returns a list of historic runs and must be paginated.
//
//    // Example sending a request using GetMLTaskRunsRequest.
//    req := client.GetMLTaskRunsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRuns
func (c *Client) GetMLTaskRunsRequest(input *GetMLTaskRunsInput) GetMLTaskRunsRequest {
	op := &aws.Operation{
		Name:       opGetMLTaskRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetMLTaskRunsInput{}
	}

	req := c.newRequest(op, input, &GetMLTaskRunsOutput{})

	return GetMLTaskRunsRequest{Request: req, Input: input, Copy: c.GetMLTaskRunsRequest}
}

// GetMLTaskRunsRequest is the request type for the
// GetMLTaskRuns API operation.
type GetMLTaskRunsRequest struct {
	*aws.Request
	Input *GetMLTaskRunsInput
	Copy  func(*GetMLTaskRunsInput) GetMLTaskRunsRequest
}

// Send marshals and sends the GetMLTaskRuns API request.
func (r GetMLTaskRunsRequest) Send(ctx context.Context) (*GetMLTaskRunsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetMLTaskRunsResponse{
		GetMLTaskRunsOutput: r.Request.Data.(*GetMLTaskRunsOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetMLTaskRunsRequestPaginator returns a paginator for GetMLTaskRuns.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetMLTaskRunsRequest(input)
//   p := glue.NewGetMLTaskRunsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetMLTaskRunsPaginator(req GetMLTaskRunsRequest) GetMLTaskRunsPaginator {
	return GetMLTaskRunsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetMLTaskRunsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetMLTaskRunsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetMLTaskRunsPaginator struct {
	aws.Pager
}

func (p *GetMLTaskRunsPaginator) CurrentPage() *GetMLTaskRunsOutput {
	return p.Pager.CurrentPage().(*GetMLTaskRunsOutput)
}

// GetMLTaskRunsResponse is the response type for the
// GetMLTaskRuns API operation.
type GetMLTaskRunsResponse struct {
	*GetMLTaskRunsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetMLTaskRuns request.
func (r *GetMLTaskRunsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
