// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartWorkflowRunInput struct {
	_ struct{} `type:"structure"`

	// The name of the workflow to start.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartWorkflowRunInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartWorkflowRunInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartWorkflowRunInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartWorkflowRunOutput struct {
	_ struct{} `type:"structure"`

	// An Id for the new run.
	RunId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartWorkflowRunOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartWorkflowRun = "StartWorkflowRun"

// StartWorkflowRunRequest returns a request value for making API operation for
// AWS Glue.
//
// Starts a new run of the specified workflow.
//
//    // Example sending a request using StartWorkflowRunRequest.
//    req := client.StartWorkflowRunRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartWorkflowRun
func (c *Client) StartWorkflowRunRequest(input *StartWorkflowRunInput) StartWorkflowRunRequest {
	op := &aws.Operation{
		Name:       opStartWorkflowRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartWorkflowRunInput{}
	}

	req := c.newRequest(op, input, &StartWorkflowRunOutput{})

	return StartWorkflowRunRequest{Request: req, Input: input, Copy: c.StartWorkflowRunRequest}
}

// StartWorkflowRunRequest is the request type for the
// StartWorkflowRun API operation.
type StartWorkflowRunRequest struct {
	*aws.Request
	Input *StartWorkflowRunInput
	Copy  func(*StartWorkflowRunInput) StartWorkflowRunRequest
}

// Send marshals and sends the StartWorkflowRun API request.
func (r StartWorkflowRunRequest) Send(ctx context.Context) (*StartWorkflowRunResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartWorkflowRunResponse{
		StartWorkflowRunOutput: r.Request.Data.(*StartWorkflowRunOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartWorkflowRunResponse is the response type for the
// StartWorkflowRun API operation.
type StartWorkflowRunResponse struct {
	*StartWorkflowRunOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartWorkflowRun request.
func (r *StartWorkflowRunResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
