// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteDeviceDefinitionInput struct {
	_ struct{} `type:"structure"`

	// DeviceDefinitionId is a required field
	DeviceDefinitionId *string `location:"uri" locationName:"DeviceDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDeviceDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeviceDefinitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDeviceDefinitionInput"}

	if s.DeviceDefinitionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDeviceDefinitionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DeviceDefinitionId != nil {
		v := *s.DeviceDefinitionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DeviceDefinitionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteDeviceDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDeviceDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDeviceDefinitionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteDeviceDefinition = "DeleteDeviceDefinition"

// DeleteDeviceDefinitionRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Deletes a device definition.
//
//    // Example sending a request using DeleteDeviceDefinitionRequest.
//    req := client.DeleteDeviceDefinitionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteDeviceDefinition
func (c *Client) DeleteDeviceDefinitionRequest(input *DeleteDeviceDefinitionInput) DeleteDeviceDefinitionRequest {
	op := &aws.Operation{
		Name:       opDeleteDeviceDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/definition/devices/{DeviceDefinitionId}",
	}

	if input == nil {
		input = &DeleteDeviceDefinitionInput{}
	}

	req := c.newRequest(op, input, &DeleteDeviceDefinitionOutput{})

	return DeleteDeviceDefinitionRequest{Request: req, Input: input, Copy: c.DeleteDeviceDefinitionRequest}
}

// DeleteDeviceDefinitionRequest is the request type for the
// DeleteDeviceDefinition API operation.
type DeleteDeviceDefinitionRequest struct {
	*aws.Request
	Input *DeleteDeviceDefinitionInput
	Copy  func(*DeleteDeviceDefinitionInput) DeleteDeviceDefinitionRequest
}

// Send marshals and sends the DeleteDeviceDefinition API request.
func (r DeleteDeviceDefinitionRequest) Send(ctx context.Context) (*DeleteDeviceDefinitionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDeviceDefinitionResponse{
		DeleteDeviceDefinitionOutput: r.Request.Data.(*DeleteDeviceDefinitionOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDeviceDefinitionResponse is the response type for the
// DeleteDeviceDefinition API operation.
type DeleteDeviceDefinitionResponse struct {
	*DeleteDeviceDefinitionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDeviceDefinition request.
func (r *DeleteDeviceDefinitionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
