// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetResourceDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	// ResourceDefinitionId is a required field
	ResourceDefinitionId *string `location:"uri" locationName:"ResourceDefinitionId" type:"string" required:"true"`

	// ResourceDefinitionVersionId is a required field
	ResourceDefinitionVersionId *string `location:"uri" locationName:"ResourceDefinitionVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResourceDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceDefinitionVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetResourceDefinitionVersionInput"}

	if s.ResourceDefinitionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceDefinitionId"))
	}

	if s.ResourceDefinitionVersionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceDefinitionVersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetResourceDefinitionVersionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ResourceDefinitionId != nil {
		v := *s.ResourceDefinitionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ResourceDefinitionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceDefinitionVersionId != nil {
		v := *s.ResourceDefinitionVersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ResourceDefinitionVersionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a resource definition version.
type GetResourceDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	// Arn of the resource definition version.
	Arn *string `type:"string"`

	// The time, in milliseconds since the epoch, when the resource definition version
	// was created.
	CreationTimestamp *string `type:"string"`

	// Information about the definition.
	Definition *ResourceDefinitionVersion `type:"structure"`

	// The ID of the resource definition version.
	Id *string `type:"string"`

	// The version of the resource definition version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s GetResourceDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetResourceDefinitionVersionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationTimestamp != nil {
		v := *s.CreationTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationTimestamp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Definition != nil {
		v := s.Definition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Definition", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetResourceDefinitionVersion = "GetResourceDefinitionVersion"

// GetResourceDefinitionVersionRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Retrieves information about a resource definition version, including which
// resources are included in the version.
//
//    // Example sending a request using GetResourceDefinitionVersionRequest.
//    req := client.GetResourceDefinitionVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinitionVersion
func (c *Client) GetResourceDefinitionVersionRequest(input *GetResourceDefinitionVersionInput) GetResourceDefinitionVersionRequest {
	op := &aws.Operation{
		Name:       opGetResourceDefinitionVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/definition/resources/{ResourceDefinitionId}/versions/{ResourceDefinitionVersionId}",
	}

	if input == nil {
		input = &GetResourceDefinitionVersionInput{}
	}

	req := c.newRequest(op, input, &GetResourceDefinitionVersionOutput{})

	return GetResourceDefinitionVersionRequest{Request: req, Input: input, Copy: c.GetResourceDefinitionVersionRequest}
}

// GetResourceDefinitionVersionRequest is the request type for the
// GetResourceDefinitionVersion API operation.
type GetResourceDefinitionVersionRequest struct {
	*aws.Request
	Input *GetResourceDefinitionVersionInput
	Copy  func(*GetResourceDefinitionVersionInput) GetResourceDefinitionVersionRequest
}

// Send marshals and sends the GetResourceDefinitionVersion API request.
func (r GetResourceDefinitionVersionRequest) Send(ctx context.Context) (*GetResourceDefinitionVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetResourceDefinitionVersionResponse{
		GetResourceDefinitionVersionOutput: r.Request.Data.(*GetResourceDefinitionVersionOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetResourceDefinitionVersionResponse is the response type for the
// GetResourceDefinitionVersion API operation.
type GetResourceDefinitionVersionResponse struct {
	*GetResourceDefinitionVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetResourceDefinitionVersion request.
func (r *GetResourceDefinitionVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
