// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package health

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeEventDetailsForOrganizationInput struct {
	_ struct{} `type:"structure"`

	// The locale (language) to return information in. English (en) is the default
	// and the only supported value at this time.
	Locale *string `locationName:"locale" min:"2" type:"string"`

	// A set of JSON elements that includes the awsAccountId and the eventArn.
	//
	// OrganizationEventDetailFilters is a required field
	OrganizationEventDetailFilters []EventAccountFilter `locationName:"organizationEventDetailFilters" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeEventDetailsForOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventDetailsForOrganizationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeEventDetailsForOrganizationInput"}
	if s.Locale != nil && len(*s.Locale) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Locale", 2))
	}

	if s.OrganizationEventDetailFilters == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrganizationEventDetailFilters"))
	}
	if s.OrganizationEventDetailFilters != nil && len(s.OrganizationEventDetailFilters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OrganizationEventDetailFilters", 1))
	}
	if s.OrganizationEventDetailFilters != nil {
		for i, v := range s.OrganizationEventDetailFilters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OrganizationEventDetailFilters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeEventDetailsForOrganizationOutput struct {
	_ struct{} `type:"structure"`

	// Error messages for any events that could not be retrieved.
	FailedSet []OrganizationEventDetailsErrorItem `locationName:"failedSet" type:"list"`

	// Information about the events that could be retrieved.
	SuccessfulSet []OrganizationEventDetails `locationName:"successfulSet" type:"list"`
}

// String returns the string representation
func (s DescribeEventDetailsForOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeEventDetailsForOrganization = "DescribeEventDetailsForOrganization"

// DescribeEventDetailsForOrganizationRequest returns a request value for making API operation for
// AWS Health APIs and Notifications.
//
// Returns detailed information about one or more specified events for one or
// more accounts in your organization. Information includes standard event data
// (Region, service, and so on, as returned by DescribeEventsForOrganization,
// a detailed event description, and possible additional metadata that depends
// upon the nature of the event. Affected entities are not included; to retrieve
// those, use the DescribeAffectedEntitiesForOrganization operation.
//
// Before you can call this operation, you must first enable AWS Health to work
// with AWS Organizations. To do this, call the EnableHealthServiceAccessForOrganization
// operation from your organization's master account.
//
//    // Example sending a request using DescribeEventDetailsForOrganizationRequest.
//    req := client.DescribeEventDetailsForOrganizationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventDetailsForOrganization
func (c *Client) DescribeEventDetailsForOrganizationRequest(input *DescribeEventDetailsForOrganizationInput) DescribeEventDetailsForOrganizationRequest {
	op := &aws.Operation{
		Name:       opDescribeEventDetailsForOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventDetailsForOrganizationInput{}
	}

	req := c.newRequest(op, input, &DescribeEventDetailsForOrganizationOutput{})

	return DescribeEventDetailsForOrganizationRequest{Request: req, Input: input, Copy: c.DescribeEventDetailsForOrganizationRequest}
}

// DescribeEventDetailsForOrganizationRequest is the request type for the
// DescribeEventDetailsForOrganization API operation.
type DescribeEventDetailsForOrganizationRequest struct {
	*aws.Request
	Input *DescribeEventDetailsForOrganizationInput
	Copy  func(*DescribeEventDetailsForOrganizationInput) DescribeEventDetailsForOrganizationRequest
}

// Send marshals and sends the DescribeEventDetailsForOrganization API request.
func (r DescribeEventDetailsForOrganizationRequest) Send(ctx context.Context) (*DescribeEventDetailsForOrganizationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeEventDetailsForOrganizationResponse{
		DescribeEventDetailsForOrganizationOutput: r.Request.Data.(*DescribeEventDetailsForOrganizationOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeEventDetailsForOrganizationResponse is the response type for the
// DescribeEventDetailsForOrganization API operation.
type DescribeEventDetailsForOrganizationResponse struct {
	*DescribeEventDetailsForOrganizationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeEventDetailsForOrganization request.
func (r *DescribeEventDetailsForOrganizationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
