// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package health

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeEventsForOrganizationInput struct {
	_ struct{} `type:"structure"`

	// Values to narrow the results returned.
	Filter *OrganizationEventFilter `locationName:"filter" type:"structure"`

	// The locale (language) to return information in. English (en) is the default
	// and the only supported value at this time.
	Locale *string `locationName:"locale" min:"2" type:"string"`

	// The maximum number of items to return in one batch, between 10 and 100, inclusive.
	MaxResults *int64 `locationName:"maxResults" min:"10" type:"integer"`

	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next batch of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s DescribeEventsForOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventsForOrganizationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeEventsForOrganizationInput"}
	if s.Locale != nil && len(*s.Locale) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Locale", 2))
	}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 10))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 4))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeEventsForOrganizationOutput struct {
	_ struct{} `type:"structure"`

	// The events that match the specified filter criteria.
	Events []OrganizationEvent `locationName:"events" type:"list"`

	// If the results of a search are large, only a portion of the results are returned,
	// and a nextToken pagination token is returned in the response. To retrieve
	// the next batch of results, reissue the search request and include the returned
	// token. When all results have been returned, the response does not contain
	// a pagination token value.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s DescribeEventsForOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeEventsForOrganization = "DescribeEventsForOrganization"

// DescribeEventsForOrganizationRequest returns a request value for making API operation for
// AWS Health APIs and Notifications.
//
// Returns information about events across your organization in AWS Organizations,
// meeting the specified filter criteria. Events are returned in a summary form
// and do not include the accounts impacted, detailed description, any additional
// metadata that depends on the event type, or any affected resources. To retrieve
// that information, use the DescribeAffectedAccountsForOrganization, DescribeEventDetailsForOrganization,
// and DescribeAffectedEntitiesForOrganization operations.
//
// If no filter criteria are specified, all events across your organization
// are returned. Results are sorted by lastModifiedTime, starting with the most
// recent.
//
// Before you can call this operation, you must first enable Health to work
// with AWS Organizations. To do this, call the EnableHealthServiceAccessForOrganization
// operation from your organization's master account.
//
//    // Example sending a request using DescribeEventsForOrganizationRequest.
//    req := client.DescribeEventsForOrganizationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventsForOrganization
func (c *Client) DescribeEventsForOrganizationRequest(input *DescribeEventsForOrganizationInput) DescribeEventsForOrganizationRequest {
	op := &aws.Operation{
		Name:       opDescribeEventsForOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventsForOrganizationInput{}
	}

	req := c.newRequest(op, input, &DescribeEventsForOrganizationOutput{})

	return DescribeEventsForOrganizationRequest{Request: req, Input: input, Copy: c.DescribeEventsForOrganizationRequest}
}

// DescribeEventsForOrganizationRequest is the request type for the
// DescribeEventsForOrganization API operation.
type DescribeEventsForOrganizationRequest struct {
	*aws.Request
	Input *DescribeEventsForOrganizationInput
	Copy  func(*DescribeEventsForOrganizationInput) DescribeEventsForOrganizationRequest
}

// Send marshals and sends the DescribeEventsForOrganization API request.
func (r DescribeEventsForOrganizationRequest) Send(ctx context.Context) (*DescribeEventsForOrganizationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeEventsForOrganizationResponse{
		DescribeEventsForOrganizationOutput: r.Request.Data.(*DescribeEventsForOrganizationOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeEventsForOrganizationRequestPaginator returns a paginator for DescribeEventsForOrganization.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeEventsForOrganizationRequest(input)
//   p := health.NewDescribeEventsForOrganizationRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeEventsForOrganizationPaginator(req DescribeEventsForOrganizationRequest) DescribeEventsForOrganizationPaginator {
	return DescribeEventsForOrganizationPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeEventsForOrganizationInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeEventsForOrganizationPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeEventsForOrganizationPaginator struct {
	aws.Pager
}

func (p *DescribeEventsForOrganizationPaginator) CurrentPage() *DescribeEventsForOrganizationOutput {
	return p.Pager.CurrentPage().(*DescribeEventsForOrganizationOutput)
}

// DescribeEventsForOrganizationResponse is the response type for the
// DescribeEventsForOrganization API operation.
type DescribeEventsForOrganizationResponse struct {
	*DescribeEventsForOrganizationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeEventsForOrganization request.
func (r *DescribeEventsForOrganizationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
