// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package healthiface provides an interface to enable mocking the AWS Health APIs and Notifications service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package healthiface

import (
	"github.com/aws/aws-sdk-go-v2/service/health"
)

// ClientAPI provides an interface to enable mocking the
// health.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWSHealth.
//    func myFunc(svc healthiface.ClientAPI) bool {
//        // Make svc.DescribeAffectedAccountsForOrganization request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := health.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        healthiface.ClientPI
//    }
//    func (m *mockClientClient) DescribeAffectedAccountsForOrganization(input *health.DescribeAffectedAccountsForOrganizationInput) (*health.DescribeAffectedAccountsForOrganizationOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	DescribeAffectedAccountsForOrganizationRequest(*health.DescribeAffectedAccountsForOrganizationInput) health.DescribeAffectedAccountsForOrganizationRequest

	DescribeAffectedEntitiesRequest(*health.DescribeAffectedEntitiesInput) health.DescribeAffectedEntitiesRequest

	DescribeAffectedEntitiesForOrganizationRequest(*health.DescribeAffectedEntitiesForOrganizationInput) health.DescribeAffectedEntitiesForOrganizationRequest

	DescribeEntityAggregatesRequest(*health.DescribeEntityAggregatesInput) health.DescribeEntityAggregatesRequest

	DescribeEventAggregatesRequest(*health.DescribeEventAggregatesInput) health.DescribeEventAggregatesRequest

	DescribeEventDetailsRequest(*health.DescribeEventDetailsInput) health.DescribeEventDetailsRequest

	DescribeEventDetailsForOrganizationRequest(*health.DescribeEventDetailsForOrganizationInput) health.DescribeEventDetailsForOrganizationRequest

	DescribeEventTypesRequest(*health.DescribeEventTypesInput) health.DescribeEventTypesRequest

	DescribeEventsRequest(*health.DescribeEventsInput) health.DescribeEventsRequest

	DescribeEventsForOrganizationRequest(*health.DescribeEventsForOrganizationInput) health.DescribeEventsForOrganizationRequest

	DescribeHealthServiceStatusForOrganizationRequest(*health.DescribeHealthServiceStatusForOrganizationInput) health.DescribeHealthServiceStatusForOrganizationRequest

	DisableHealthServiceAccessForOrganizationRequest(*health.DisableHealthServiceAccessForOrganizationInput) health.DisableHealthServiceAccessForOrganizationRequest

	EnableHealthServiceAccessForOrganizationRequest(*health.EnableHealthServiceAccessForOrganizationInput) health.EnableHealthServiceAccessForOrganizationRequest
}

var _ ClientAPI = (*health.Client)(nil)
