// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListPoliciesGrantingServiceAccessInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM identity (user, group, or role) whose policies you want
	// to list.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// The service namespace for the AWS services whose policies you want to list.
	//
	// To learn the service namespace for a service, go to Actions, Resources, and
	// Condition Keys for AWS Services (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html)
	// in the IAM User Guide. Choose the name of the service to view details for
	// that service. In the first paragraph, find the service prefix. For example,
	// (service prefix: a4b). For more information about service namespaces, see
	// AWS Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the AWS General Reference.
	//
	// ServiceNamespaces is a required field
	ServiceNamespaces []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s ListPoliciesGrantingServiceAccessInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPoliciesGrantingServiceAccessInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPoliciesGrantingServiceAccessInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 20))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Marker", 1))
	}

	if s.ServiceNamespaces == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceNamespaces"))
	}
	if s.ServiceNamespaces != nil && len(s.ServiceNamespaces) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServiceNamespaces", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListPoliciesGrantingServiceAccessOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. We recommend that you check IsTruncated
	// after every call to ensure that you receive all your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `type:"string"`

	// A ListPoliciesGrantingServiceAccess object that contains details about the
	// permissions policies attached to the specified identity (user, group, or
	// role).
	//
	// PoliciesGrantingServiceAccess is a required field
	PoliciesGrantingServiceAccess []ListPoliciesGrantingServiceAccessEntry `type:"list" required:"true"`
}

// String returns the string representation
func (s ListPoliciesGrantingServiceAccessOutput) String() string {
	return awsutil.Prettify(s)
}

const opListPoliciesGrantingServiceAccess = "ListPoliciesGrantingServiceAccess"

// ListPoliciesGrantingServiceAccessRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Retrieves a list of policies that the IAM identity (user, group, or role)
// can use to access each specified service.
//
// This operation does not use other policy types when determining whether a
// resource could access a service. These other policy types include resource-based
// policies, access control lists, AWS Organizations policies, IAM permissions
// boundaries, and AWS STS assume role policies. It only applies permissions
// policy logic. For more about the evaluation of policy types, see Evaluating
// Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics)
// in the IAM User Guide.
//
// The list of policies returned by the operation depends on the ARN of the
// identity that you provide.
//
//    * User – The list of policies includes the managed and inline policies
//    that are attached to the user directly. The list also includes any additional
//    managed and inline policies that are attached to the group to which the
//    user belongs.
//
//    * Group – The list of policies includes only the managed and inline
//    policies that are attached to the group directly. Policies that are attached
//    to the group’s user are not included.
//
//    * Role – The list of policies includes only the managed and inline policies
//    that are attached to the role.
//
// For each managed policy, this operation returns the ARN and policy name.
// For each inline policy, it returns the policy name and the entity to which
// it is attached. Inline policies do not have an ARN. For more information
// about these policy types, see Managed Policies and Inline Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html)
// in the IAM User Guide.
//
// Policies that are attached to users and roles as permissions boundaries are
// not returned. To view which managed policy is currently used to set the permissions
// boundary for a user or role, use the GetUser or GetRole operations.
//
//    // Example sending a request using ListPoliciesGrantingServiceAccessRequest.
//    req := client.ListPoliciesGrantingServiceAccessRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPoliciesGrantingServiceAccess
func (c *Client) ListPoliciesGrantingServiceAccessRequest(input *ListPoliciesGrantingServiceAccessInput) ListPoliciesGrantingServiceAccessRequest {
	op := &aws.Operation{
		Name:       opListPoliciesGrantingServiceAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPoliciesGrantingServiceAccessInput{}
	}

	req := c.newRequest(op, input, &ListPoliciesGrantingServiceAccessOutput{})

	return ListPoliciesGrantingServiceAccessRequest{Request: req, Input: input, Copy: c.ListPoliciesGrantingServiceAccessRequest}
}

// ListPoliciesGrantingServiceAccessRequest is the request type for the
// ListPoliciesGrantingServiceAccess API operation.
type ListPoliciesGrantingServiceAccessRequest struct {
	*aws.Request
	Input *ListPoliciesGrantingServiceAccessInput
	Copy  func(*ListPoliciesGrantingServiceAccessInput) ListPoliciesGrantingServiceAccessRequest
}

// Send marshals and sends the ListPoliciesGrantingServiceAccess API request.
func (r ListPoliciesGrantingServiceAccessRequest) Send(ctx context.Context) (*ListPoliciesGrantingServiceAccessResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPoliciesGrantingServiceAccessResponse{
		ListPoliciesGrantingServiceAccessOutput: r.Request.Data.(*ListPoliciesGrantingServiceAccessOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListPoliciesGrantingServiceAccessResponse is the response type for the
// ListPoliciesGrantingServiceAccess API operation.
type ListPoliciesGrantingServiceAccessResponse struct {
	*ListPoliciesGrantingServiceAccessOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPoliciesGrantingServiceAccess request.
func (r *ListPoliciesGrantingServiceAccessResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
