// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package imagebuilder

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateImageRecipeInput struct {
	_ struct{} `type:"structure"`

	// The block device mappings of the image recipe.
	BlockDeviceMappings []InstanceBlockDeviceMapping `locationName:"blockDeviceMappings" type:"list"`

	// The idempotency token used to make this request idempotent.
	//
	// ClientToken is a required field
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" required:"true" idempotencyToken:"true"`

	// The components of the image recipe.
	//
	// Components is a required field
	Components []ComponentConfiguration `locationName:"components" min:"1" type:"list" required:"true"`

	// The description of the image recipe.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the image recipe.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The parent image of the image recipe. The value of the string can be the
	// ARN of the parent image or an AMI ID. The format for the ARN follows this
	// example: arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/2019.x.x.
	// The ARN ends with /20xx.x.x, which communicates to EC2 Image Builder that
	// you want to use the latest AMI created in 20xx (year). You can provide the
	// specific version that you want to use, or you can use a wildcard in all of
	// the fields. If you enter an AMI ID for the string value, you must have access
	// to the AMI, and the AMI must be in the same Region in which you are using
	// Image Builder.
	//
	// ParentImage is a required field
	ParentImage *string `locationName:"parentImage" min:"1" type:"string" required:"true"`

	// The semantic version of the image recipe.
	//
	// SemanticVersion is a required field
	SemanticVersion *string `locationName:"semanticVersion" type:"string" required:"true"`

	// The tags of the image recipe.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`

	// The working directory to be used during build and test workflows.
	WorkingDirectory *string `locationName:"workingDirectory" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateImageRecipeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateImageRecipeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateImageRecipeInput"}

	if s.ClientToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientToken", 1))
	}

	if s.Components == nil {
		invalidParams.Add(aws.NewErrParamRequired("Components"))
	}
	if s.Components != nil && len(s.Components) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Components", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.ParentImage == nil {
		invalidParams.Add(aws.NewErrParamRequired("ParentImage"))
	}
	if s.ParentImage != nil && len(*s.ParentImage) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ParentImage", 1))
	}

	if s.SemanticVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("SemanticVersion"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.WorkingDirectory != nil && len(*s.WorkingDirectory) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WorkingDirectory", 1))
	}
	if s.BlockDeviceMappings != nil {
		for i, v := range s.BlockDeviceMappings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BlockDeviceMappings", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Components != nil {
		for i, v := range s.Components {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Components", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateImageRecipeInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.BlockDeviceMappings != nil {
		v := s.BlockDeviceMappings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "blockDeviceMappings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Components != nil {
		v := s.Components

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "components", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ParentImage != nil {
		v := *s.ParentImage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "parentImage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SemanticVersion != nil {
		v := *s.SemanticVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "semanticVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.WorkingDirectory != nil {
		v := *s.WorkingDirectory

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "workingDirectory", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateImageRecipeOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the image recipe that was created by this
	// request.
	ImageRecipeArn *string `locationName:"imageRecipeArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateImageRecipeOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateImageRecipeOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ClientToken != nil {
		v := *s.ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageRecipeArn != nil {
		v := *s.ImageRecipeArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "imageRecipeArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "requestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateImageRecipe = "CreateImageRecipe"

// CreateImageRecipeRequest returns a request value for making API operation for
// EC2 Image Builder.
//
// Creates a new image recipe. Image recipes define how images are configured,
// tested, and assessed.
//
//    // Example sending a request using CreateImageRecipeRequest.
//    req := client.CreateImageRecipeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateImageRecipe
func (c *Client) CreateImageRecipeRequest(input *CreateImageRecipeInput) CreateImageRecipeRequest {
	op := &aws.Operation{
		Name:       opCreateImageRecipe,
		HTTPMethod: "PUT",
		HTTPPath:   "/CreateImageRecipe",
	}

	if input == nil {
		input = &CreateImageRecipeInput{}
	}

	req := c.newRequest(op, input, &CreateImageRecipeOutput{})

	return CreateImageRecipeRequest{Request: req, Input: input, Copy: c.CreateImageRecipeRequest}
}

// CreateImageRecipeRequest is the request type for the
// CreateImageRecipe API operation.
type CreateImageRecipeRequest struct {
	*aws.Request
	Input *CreateImageRecipeInput
	Copy  func(*CreateImageRecipeInput) CreateImageRecipeRequest
}

// Send marshals and sends the CreateImageRecipe API request.
func (r CreateImageRecipeRequest) Send(ctx context.Context) (*CreateImageRecipeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateImageRecipeResponse{
		CreateImageRecipeOutput: r.Request.Data.(*CreateImageRecipeOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateImageRecipeResponse is the response type for the
// CreateImageRecipe API operation.
type CreateImageRecipeResponse struct {
	*CreateImageRecipeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateImageRecipe request.
func (r *CreateImageRecipeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
