// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package imagebuilder

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetComponentPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the component whose policy you want to
	// retrieve.
	//
	// ComponentArn is a required field
	ComponentArn *string `location:"querystring" locationName:"componentArn" type:"string" required:"true"`
}

// String returns the string representation
func (s GetComponentPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComponentPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetComponentPolicyInput"}

	if s.ComponentArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ComponentArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetComponentPolicyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ComponentArn != nil {
		v := *s.ComponentArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "componentArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetComponentPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The component policy.
	Policy *string `locationName:"policy" min:"1" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation
func (s GetComponentPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetComponentPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Policy != nil {
		v := *s.Policy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "policy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "requestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetComponentPolicy = "GetComponentPolicy"

// GetComponentPolicyRequest returns a request value for making API operation for
// EC2 Image Builder.
//
// Gets a component policy.
//
//    // Example sending a request using GetComponentPolicyRequest.
//    req := client.GetComponentPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/GetComponentPolicy
func (c *Client) GetComponentPolicyRequest(input *GetComponentPolicyInput) GetComponentPolicyRequest {
	op := &aws.Operation{
		Name:       opGetComponentPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/GetComponentPolicy",
	}

	if input == nil {
		input = &GetComponentPolicyInput{}
	}

	req := c.newRequest(op, input, &GetComponentPolicyOutput{})

	return GetComponentPolicyRequest{Request: req, Input: input, Copy: c.GetComponentPolicyRequest}
}

// GetComponentPolicyRequest is the request type for the
// GetComponentPolicy API operation.
type GetComponentPolicyRequest struct {
	*aws.Request
	Input *GetComponentPolicyInput
	Copy  func(*GetComponentPolicyInput) GetComponentPolicyRequest
}

// Send marshals and sends the GetComponentPolicy API request.
func (r GetComponentPolicyRequest) Send(ctx context.Context) (*GetComponentPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetComponentPolicyResponse{
		GetComponentPolicyOutput: r.Request.Data.(*GetComponentPolicyOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetComponentPolicyResponse is the response type for the
// GetComponentPolicy API operation.
type GetComponentPolicyResponse struct {
	*GetComponentPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetComponentPolicy request.
func (r *GetComponentPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
