// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListDimensionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve at one time.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDimensionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDimensionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListDimensionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListDimensionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListDimensionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the names of the defined dimensions. Use DescribeDimension to get
	// details for a dimension.
	DimensionNames []string `locationName:"dimensionNames" type:"list"`

	// A token that can be used to retrieve the next set of results, or null if
	// there are no additional results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDimensionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListDimensionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DimensionNames != nil {
		v := s.DimensionNames

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "dimensionNames", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListDimensions = "ListDimensions"

// ListDimensionsRequest returns a request value for making API operation for
// AWS IoT.
//
// List the set of dimensions that are defined for your AWS account.
//
//    // Example sending a request using ListDimensionsRequest.
//    req := client.ListDimensionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListDimensionsRequest(input *ListDimensionsInput) ListDimensionsRequest {
	op := &aws.Operation{
		Name:       opListDimensions,
		HTTPMethod: "GET",
		HTTPPath:   "/dimensions",
	}

	if input == nil {
		input = &ListDimensionsInput{}
	}

	req := c.newRequest(op, input, &ListDimensionsOutput{})

	return ListDimensionsRequest{Request: req, Input: input, Copy: c.ListDimensionsRequest}
}

// ListDimensionsRequest is the request type for the
// ListDimensions API operation.
type ListDimensionsRequest struct {
	*aws.Request
	Input *ListDimensionsInput
	Copy  func(*ListDimensionsInput) ListDimensionsRequest
}

// Send marshals and sends the ListDimensions API request.
func (r ListDimensionsRequest) Send(ctx context.Context) (*ListDimensionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDimensionsResponse{
		ListDimensionsOutput: r.Request.Data.(*ListDimensionsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListDimensionsResponse is the response type for the
// ListDimensions API operation.
type ListDimensionsResponse struct {
	*ListDimensionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDimensions request.
func (r *ListDimensionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
