// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotevents

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateDetectorModelInput struct {
	_ struct{} `type:"structure"`

	// Information that defines how a detector operates.
	//
	// DetectorModelDefinition is a required field
	DetectorModelDefinition *DetectorModelDefinition `locationName:"detectorModelDefinition" type:"structure" required:"true"`

	// A brief description of the detector model.
	DetectorModelDescription *string `locationName:"detectorModelDescription" type:"string"`

	// The name of the detector model that is updated.
	//
	// DetectorModelName is a required field
	DetectorModelName *string `location:"uri" locationName:"detectorModelName" min:"1" type:"string" required:"true"`

	// Information about the order in which events are evaluated and how actions
	// are executed.
	EvaluationMethod EvaluationMethod `locationName:"evaluationMethod" type:"string" enum:"true"`

	// The ARN of the role that grants permission to AWS IoT Events to perform its
	// operations.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDetectorModelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDetectorModelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDetectorModelInput"}

	if s.DetectorModelDefinition == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorModelDefinition"))
	}

	if s.DetectorModelName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorModelName"))
	}
	if s.DetectorModelName != nil && len(*s.DetectorModelName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DetectorModelName", 1))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 1))
	}
	if s.DetectorModelDefinition != nil {
		if err := s.DetectorModelDefinition.Validate(); err != nil {
			invalidParams.AddNested("DetectorModelDefinition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDetectorModelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DetectorModelDefinition != nil {
		v := s.DetectorModelDefinition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "detectorModelDefinition", v, metadata)
	}
	if s.DetectorModelDescription != nil {
		v := *s.DetectorModelDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detectorModelDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.EvaluationMethod) > 0 {
		v := s.EvaluationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "evaluationMethod", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DetectorModelName != nil {
		v := *s.DetectorModelName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "detectorModelName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateDetectorModelOutput struct {
	_ struct{} `type:"structure"`

	// Information about how the detector model is configured.
	DetectorModelConfiguration *DetectorModelConfiguration `locationName:"detectorModelConfiguration" type:"structure"`
}

// String returns the string representation
func (s UpdateDetectorModelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDetectorModelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DetectorModelConfiguration != nil {
		v := s.DetectorModelConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "detectorModelConfiguration", v, metadata)
	}
	return nil
}

const opUpdateDetectorModel = "UpdateDetectorModel"

// UpdateDetectorModelRequest returns a request value for making API operation for
// AWS IoT Events.
//
// Updates a detector model. Detectors (instances) spawned by the previous version
// are deleted and then re-created as new inputs arrive.
//
//    // Example sending a request using UpdateDetectorModelRequest.
//    req := client.UpdateDetectorModelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/UpdateDetectorModel
func (c *Client) UpdateDetectorModelRequest(input *UpdateDetectorModelInput) UpdateDetectorModelRequest {
	op := &aws.Operation{
		Name:       opUpdateDetectorModel,
		HTTPMethod: "POST",
		HTTPPath:   "/detector-models/{detectorModelName}",
	}

	if input == nil {
		input = &UpdateDetectorModelInput{}
	}

	req := c.newRequest(op, input, &UpdateDetectorModelOutput{})

	return UpdateDetectorModelRequest{Request: req, Input: input, Copy: c.UpdateDetectorModelRequest}
}

// UpdateDetectorModelRequest is the request type for the
// UpdateDetectorModel API operation.
type UpdateDetectorModelRequest struct {
	*aws.Request
	Input *UpdateDetectorModelInput
	Copy  func(*UpdateDetectorModelInput) UpdateDetectorModelRequest
}

// Send marshals and sends the UpdateDetectorModel API request.
func (r UpdateDetectorModelRequest) Send(ctx context.Context) (*UpdateDetectorModelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDetectorModelResponse{
		UpdateDetectorModelOutput: r.Request.Data.(*UpdateDetectorModelOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDetectorModelResponse is the response type for the
// UpdateDetectorModel API operation.
type UpdateDetectorModelResponse struct {
	*UpdateDetectorModelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDetectorModel request.
func (r *UpdateDetectorModelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
