// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateAssetModelInput struct {
	_ struct{} `type:"structure"`

	// A description for the asset model.
	AssetModelDescription *string `locationName:"assetModelDescription" min:"1" type:"string"`

	// The hierarchy definitions of the asset model. Each hierarchy specifies an
	// asset model whose assets can be children of any other assets created from
	// this asset model. For more information, see Asset Hierarchies (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// You can specify up to 10 hierarchies per asset model. For more information,
	// see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
	// in the AWS IoT SiteWise User Guide.
	AssetModelHierarchies []AssetModelHierarchyDefinition `locationName:"assetModelHierarchies" type:"list"`

	// A unique, friendly name for the asset model.
	//
	// AssetModelName is a required field
	AssetModelName *string `locationName:"assetModelName" min:"1" type:"string" required:"true"`

	// The property definitions of the asset model. For more information, see Asset
	// Properties (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// You can specify up to 200 properties per asset model. For more information,
	// see Quotas (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html)
	// in the AWS IoT SiteWise User Guide.
	AssetModelProperties []AssetModelPropertyDefinition `locationName:"assetModelProperties" type:"list"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// A list of key-value pairs that contain metadata for the asset model. For
	// more information, see Tagging your AWS IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the AWS IoT SiteWise User Guide.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s CreateAssetModelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssetModelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateAssetModelInput"}
	if s.AssetModelDescription != nil && len(*s.AssetModelDescription) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssetModelDescription", 1))
	}

	if s.AssetModelName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssetModelName"))
	}
	if s.AssetModelName != nil && len(*s.AssetModelName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssetModelName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientToken", 36))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.AssetModelHierarchies != nil {
		for i, v := range s.AssetModelHierarchies {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetModelHierarchies", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.AssetModelProperties != nil {
		for i, v := range s.AssetModelProperties {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetModelProperties", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateAssetModelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AssetModelDescription != nil {
		v := *s.AssetModelDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assetModelDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssetModelHierarchies != nil {
		v := s.AssetModelHierarchies

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "assetModelHierarchies", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.AssetModelName != nil {
		v := *s.AssetModelName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assetModelName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssetModelProperties != nil {
		v := s.AssetModelProperties

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "assetModelProperties", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

type CreateAssetModelOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the asset model, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}
	//
	// AssetModelArn is a required field
	AssetModelArn *string `locationName:"assetModelArn" min:"1" type:"string" required:"true"`

	// The ID of the asset model. You can use this ID when you call other AWS IoT
	// SiteWise APIs.
	//
	// AssetModelId is a required field
	AssetModelId *string `locationName:"assetModelId" min:"36" type:"string" required:"true"`

	// The status of the asset model, which contains a state (CREATING after successfully
	// calling this operation) and any error message.
	//
	// AssetModelStatus is a required field
	AssetModelStatus *AssetModelStatus `locationName:"assetModelStatus" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAssetModelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateAssetModelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssetModelArn != nil {
		v := *s.AssetModelArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assetModelArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssetModelId != nil {
		v := *s.AssetModelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assetModelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssetModelStatus != nil {
		v := s.AssetModelStatus

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "assetModelStatus", v, metadata)
	}
	return nil
}

const opCreateAssetModel = "CreateAssetModel"

// CreateAssetModelRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Creates an asset model from specified property and hierarchy definitions.
// You create assets from asset models. With asset models, you can easily create
// assets of the same type that have standardized definitions. Each asset created
// from a model inherits the asset model's property and hierarchy definitions.
// For more information, see Defining Asset Models (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/define-models.html)
// in the AWS IoT SiteWise User Guide.
//
//    // Example sending a request using CreateAssetModelRequest.
//    req := client.CreateAssetModelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAssetModel
func (c *Client) CreateAssetModelRequest(input *CreateAssetModelInput) CreateAssetModelRequest {
	op := &aws.Operation{
		Name:       opCreateAssetModel,
		HTTPMethod: "POST",
		HTTPPath:   "/asset-models",
	}

	if input == nil {
		input = &CreateAssetModelInput{}
	}

	req := c.newRequest(op, input, &CreateAssetModelOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return CreateAssetModelRequest{Request: req, Input: input, Copy: c.CreateAssetModelRequest}
}

// CreateAssetModelRequest is the request type for the
// CreateAssetModel API operation.
type CreateAssetModelRequest struct {
	*aws.Request
	Input *CreateAssetModelInput
	Copy  func(*CreateAssetModelInput) CreateAssetModelRequest
}

// Send marshals and sends the CreateAssetModel API request.
func (r CreateAssetModelRequest) Send(ctx context.Context) (*CreateAssetModelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateAssetModelResponse{
		CreateAssetModelOutput: r.Request.Data.(*CreateAssetModelOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateAssetModelResponse is the response type for the
// CreateAssetModel API operation.
type CreateAssetModelResponse struct {
	*CreateAssetModelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateAssetModel request.
func (r *CreateAssetModelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
