// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeletePortalInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The ID of the portal to delete.
	//
	// PortalId is a required field
	PortalId *string `location:"uri" locationName:"portalId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePortalInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePortalInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeletePortalInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientToken", 36))
	}

	if s.PortalId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PortalId"))
	}
	if s.PortalId != nil && len(*s.PortalId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("PortalId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePortalInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.PortalId != nil {
		v := *s.PortalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "portalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeletePortalOutput struct {
	_ struct{} `type:"structure"`

	// The status of the portal, which contains a state (DELETING after successfully
	// calling this operation) and any error message.
	//
	// PortalStatus is a required field
	PortalStatus *PortalStatus `locationName:"portalStatus" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeletePortalOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePortalOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.PortalStatus != nil {
		v := s.PortalStatus

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "portalStatus", v, metadata)
	}
	return nil
}

const opDeletePortal = "DeletePortal"

// DeletePortalRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Deletes a portal from AWS IoT SiteWise Monitor.
//
//    // Example sending a request using DeletePortalRequest.
//    req := client.DeletePortalRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeletePortal
func (c *Client) DeletePortalRequest(input *DeletePortalInput) DeletePortalRequest {
	op := &aws.Operation{
		Name:       opDeletePortal,
		HTTPMethod: "DELETE",
		HTTPPath:   "/portals/{portalId}",
	}

	if input == nil {
		input = &DeletePortalInput{}
	}

	req := c.newRequest(op, input, &DeletePortalOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return DeletePortalRequest{Request: req, Input: input, Copy: c.DeletePortalRequest}
}

// DeletePortalRequest is the request type for the
// DeletePortal API operation.
type DeletePortalRequest struct {
	*aws.Request
	Input *DeletePortalInput
	Copy  func(*DeletePortalInput) DeletePortalRequest
}

// Send marshals and sends the DeletePortal API request.
func (r DeletePortalRequest) Send(ctx context.Context) (*DeletePortalResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeletePortalResponse{
		DeletePortalOutput: r.Request.Data.(*DeletePortalOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeletePortalResponse is the response type for the
// DeletePortal API operation.
type DeletePortalResponse struct {
	*DeletePortalOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeletePortal request.
func (r *DeletePortalResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
