// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetAssetPropertyValueHistoryInput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset.
	AssetId *string `location:"querystring" locationName:"assetId" min:"36" type:"string"`

	// The inclusive end of the range from which to query historical data, expressed
	// in seconds in Unix epoch time.
	EndDate *time.Time `location:"querystring" locationName:"endDate" type:"timestamp"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The property alias that identifies the property, such as an OPC-UA server
	// data stream path (for example, /company/windfarm/3/turbine/7/temperature).
	// For more information, see Mapping Industrial Data Streams to Asset Properties
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the AWS IoT SiteWise User Guide.
	PropertyAlias *string `location:"querystring" locationName:"propertyAlias" min:"1" type:"string"`

	// The ID of the asset property.
	PropertyId *string `location:"querystring" locationName:"propertyId" min:"36" type:"string"`

	// The quality by which to filter asset data.
	Qualities []Quality `location:"querystring" locationName:"qualities" min:"1" type:"list"`

	// The exclusive start of the range from which to query historical data, expressed
	// in seconds in Unix epoch time.
	StartDate *time.Time `location:"querystring" locationName:"startDate" type:"timestamp"`

	// The chronological sorting order of the requested information.
	TimeOrdering TimeOrdering `location:"querystring" locationName:"timeOrdering" type:"string" enum:"true"`
}

// String returns the string representation
func (s GetAssetPropertyValueHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssetPropertyValueHistoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetAssetPropertyValueHistoryInput"}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("AssetId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.PropertyAlias != nil && len(*s.PropertyAlias) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PropertyAlias", 1))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("PropertyId", 36))
	}
	if s.Qualities != nil && len(s.Qualities) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Qualities", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAssetPropertyValueHistoryInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AssetId != nil {
		v := *s.AssetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "assetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndDate != nil {
		v := *s.EndDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "endDate",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PropertyAlias != nil {
		v := *s.PropertyAlias

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "propertyAlias", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PropertyId != nil {
		v := *s.PropertyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "propertyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Qualities != nil {
		v := s.Qualities

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.QueryTarget, "qualities", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.StartDate != nil {
		v := *s.StartDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "startDate",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if len(s.TimeOrdering) > 0 {
		v := s.TimeOrdering

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "timeOrdering", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type GetAssetPropertyValueHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The asset property's value history.
	//
	// AssetPropertyValueHistory is a required field
	AssetPropertyValueHistory []AssetPropertyValue `locationName:"assetPropertyValueHistory" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetAssetPropertyValueHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAssetPropertyValueHistoryOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssetPropertyValueHistory != nil {
		v := s.AssetPropertyValueHistory

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "assetPropertyValueHistory", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetAssetPropertyValueHistory = "GetAssetPropertyValueHistory"

// GetAssetPropertyValueHistoryRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Gets the history of an asset property's values. For more information, see
// Querying Historical Property Values (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values)
// in the AWS IoT SiteWise User Guide.
//
// To identify an asset property, you must specify one of the following:
//
//    * The assetId and propertyId of an asset property.
//
//    * A propertyAlias, which is a data stream alias (for example, /company/windfarm/3/turbine/7/temperature).
//    To define an asset property's alias, see UpdateAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
//
//    // Example sending a request using GetAssetPropertyValueHistoryRequest.
//    req := client.GetAssetPropertyValueHistoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValueHistory
func (c *Client) GetAssetPropertyValueHistoryRequest(input *GetAssetPropertyValueHistoryInput) GetAssetPropertyValueHistoryRequest {
	op := &aws.Operation{
		Name:       opGetAssetPropertyValueHistory,
		HTTPMethod: "GET",
		HTTPPath:   "/properties/history",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetAssetPropertyValueHistoryInput{}
	}

	req := c.newRequest(op, input, &GetAssetPropertyValueHistoryOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("data.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return GetAssetPropertyValueHistoryRequest{Request: req, Input: input, Copy: c.GetAssetPropertyValueHistoryRequest}
}

// GetAssetPropertyValueHistoryRequest is the request type for the
// GetAssetPropertyValueHistory API operation.
type GetAssetPropertyValueHistoryRequest struct {
	*aws.Request
	Input *GetAssetPropertyValueHistoryInput
	Copy  func(*GetAssetPropertyValueHistoryInput) GetAssetPropertyValueHistoryRequest
}

// Send marshals and sends the GetAssetPropertyValueHistory API request.
func (r GetAssetPropertyValueHistoryRequest) Send(ctx context.Context) (*GetAssetPropertyValueHistoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAssetPropertyValueHistoryResponse{
		GetAssetPropertyValueHistoryOutput: r.Request.Data.(*GetAssetPropertyValueHistoryOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetAssetPropertyValueHistoryRequestPaginator returns a paginator for GetAssetPropertyValueHistory.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetAssetPropertyValueHistoryRequest(input)
//   p := iotsitewise.NewGetAssetPropertyValueHistoryRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetAssetPropertyValueHistoryPaginator(req GetAssetPropertyValueHistoryRequest) GetAssetPropertyValueHistoryPaginator {
	return GetAssetPropertyValueHistoryPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetAssetPropertyValueHistoryInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetAssetPropertyValueHistoryPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetAssetPropertyValueHistoryPaginator struct {
	aws.Pager
}

func (p *GetAssetPropertyValueHistoryPaginator) CurrentPage() *GetAssetPropertyValueHistoryOutput {
	return p.Pager.CurrentPage().(*GetAssetPropertyValueHistoryOutput)
}

// GetAssetPropertyValueHistoryResponse is the response type for the
// GetAssetPropertyValueHistory API operation.
type GetAssetPropertyValueHistoryResponse struct {
	*GetAssetPropertyValueHistoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAssetPropertyValueHistory request.
func (r *GetAssetPropertyValueHistoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
