// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type UpdateAssetPropertyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset to be updated.
	//
	// AssetId is a required field
	AssetId *string `location:"uri" locationName:"assetId" min:"36" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The property alias that identifies the property, such as an OPC-UA server
	// data stream path (for example, /company/windfarm/3/turbine/7/temperature).
	// For more information, see Mapping Industrial Data Streams to Asset Properties
	// (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// If you omit this parameter, the alias is removed from the property.
	PropertyAlias *string `locationName:"propertyAlias" min:"1" type:"string"`

	// The ID of the asset property to be updated.
	//
	// PropertyId is a required field
	PropertyId *string `location:"uri" locationName:"propertyId" min:"36" type:"string" required:"true"`

	// The MQTT notification state (enabled or disabled) for this asset property.
	// When the notification state is enabled, AWS IoT SiteWise publishes property
	// value updates to a unique MQTT topic. For more information, see Interacting
	// with Other Services (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// If you omit this parameter, the notification state is set to DISABLED.
	PropertyNotificationState PropertyNotificationState `locationName:"propertyNotificationState" type:"string" enum:"true"`
}

// String returns the string representation
func (s UpdateAssetPropertyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAssetPropertyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateAssetPropertyInput"}

	if s.AssetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssetId"))
	}
	if s.AssetId != nil && len(*s.AssetId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("AssetId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientToken", 36))
	}
	if s.PropertyAlias != nil && len(*s.PropertyAlias) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PropertyAlias", 1))
	}

	if s.PropertyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PropertyId"))
	}
	if s.PropertyId != nil && len(*s.PropertyId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("PropertyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateAssetPropertyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PropertyAlias != nil {
		v := *s.PropertyAlias

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "propertyAlias", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PropertyNotificationState) > 0 {
		v := s.PropertyNotificationState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "propertyNotificationState", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AssetId != nil {
		v := *s.AssetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "assetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PropertyId != nil {
		v := *s.PropertyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "propertyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateAssetPropertyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAssetPropertyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateAssetPropertyOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateAssetProperty = "UpdateAssetProperty"

// UpdateAssetPropertyRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Updates an asset property's alias and notification state.
//
// This operation overwrites the property's existing alias and notification
// state. To keep your existing property's alias or notification state, you
// must include the existing values in the UpdateAssetProperty request. For
// more information, see DescribeAssetProperty (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetProperty.html).
//
//    // Example sending a request using UpdateAssetPropertyRequest.
//    req := client.UpdateAssetPropertyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetProperty
func (c *Client) UpdateAssetPropertyRequest(input *UpdateAssetPropertyInput) UpdateAssetPropertyRequest {
	op := &aws.Operation{
		Name:       opUpdateAssetProperty,
		HTTPMethod: "PUT",
		HTTPPath:   "/assets/{assetId}/properties/{propertyId}",
	}

	if input == nil {
		input = &UpdateAssetPropertyInput{}
	}

	req := c.newRequest(op, input, &UpdateAssetPropertyOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("model.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return UpdateAssetPropertyRequest{Request: req, Input: input, Copy: c.UpdateAssetPropertyRequest}
}

// UpdateAssetPropertyRequest is the request type for the
// UpdateAssetProperty API operation.
type UpdateAssetPropertyRequest struct {
	*aws.Request
	Input *UpdateAssetPropertyInput
	Copy  func(*UpdateAssetPropertyInput) UpdateAssetPropertyRequest
}

// Send marshals and sends the UpdateAssetProperty API request.
func (r UpdateAssetPropertyRequest) Send(ctx context.Context) (*UpdateAssetPropertyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateAssetPropertyResponse{
		UpdateAssetPropertyOutput: r.Request.Data.(*UpdateAssetPropertyOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateAssetPropertyResponse is the response type for the
// UpdateAssetProperty API operation.
type UpdateAssetPropertyResponse struct {
	*UpdateAssetPropertyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateAssetProperty request.
func (r *UpdateAssetPropertyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
