// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotthingsgraph

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UndeploySystemInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the system instance to remove from its target.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s UndeploySystemInstanceInput) String() string {
	return awsutil.Prettify(s)
}

type UndeploySystemInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains summary information about the system instance that
	// was removed from its target.
	Summary *SystemInstanceSummary `locationName:"summary" type:"structure"`
}

// String returns the string representation
func (s UndeploySystemInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opUndeploySystemInstance = "UndeploySystemInstance"

// UndeploySystemInstanceRequest returns a request value for making API operation for
// AWS IoT Things Graph.
//
// Removes a system instance from its target (Cloud or Greengrass).
//
//    // Example sending a request using UndeploySystemInstanceRequest.
//    req := client.UndeploySystemInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UndeploySystemInstance
func (c *Client) UndeploySystemInstanceRequest(input *UndeploySystemInstanceInput) UndeploySystemInstanceRequest {
	op := &aws.Operation{
		Name:       opUndeploySystemInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UndeploySystemInstanceInput{}
	}

	req := c.newRequest(op, input, &UndeploySystemInstanceOutput{})

	return UndeploySystemInstanceRequest{Request: req, Input: input, Copy: c.UndeploySystemInstanceRequest}
}

// UndeploySystemInstanceRequest is the request type for the
// UndeploySystemInstance API operation.
type UndeploySystemInstanceRequest struct {
	*aws.Request
	Input *UndeploySystemInstanceInput
	Copy  func(*UndeploySystemInstanceInput) UndeploySystemInstanceRequest
}

// Send marshals and sends the UndeploySystemInstance API request.
func (r UndeploySystemInstanceRequest) Send(ctx context.Context) (*UndeploySystemInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UndeploySystemInstanceResponse{
		UndeploySystemInstanceOutput: r.Request.Data.(*UndeploySystemInstanceOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UndeploySystemInstanceResponse is the response type for the
// UndeploySystemInstance API operation.
type UndeploySystemInstanceResponse struct {
	*UndeploySystemInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UndeploySystemInstance request.
func (r *UndeploySystemInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
