// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ivs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type StopStreamInput struct {
	_ struct{} `type:"structure"`

	// ARN of the channel for which the stream is to be stopped.
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopStreamInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopStreamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopStreamInput"}

	if s.ChannelArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChannelArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StopStreamInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ChannelArn != nil {
		v := *s.ChannelArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type StopStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StopStreamOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opStopStream = "StopStream"

// StopStreamRequest returns a request value for making API operation for
// Amazon Interactive Video Service.
//
// Disconnects the stream for the specified channel. This disconnects the incoming
// RTMP stream from the client. Can be used in conjunction with DeleteStreamKey
// to prevent further streaming to a channel.
//
// Many streaming client-software libraries automatically reconnect a dropped
// RTMP session, so to stop the stream permanently, you may want to first revoke
// the streamKey attached to the channel.
//
//    // Example sending a request using StopStreamRequest.
//    req := client.StopStreamRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/StopStream
func (c *Client) StopStreamRequest(input *StopStreamInput) StopStreamRequest {
	op := &aws.Operation{
		Name:       opStopStream,
		HTTPMethod: "POST",
		HTTPPath:   "/StopStream",
	}

	if input == nil {
		input = &StopStreamInput{}
	}

	req := c.newRequest(op, input, &StopStreamOutput{})

	return StopStreamRequest{Request: req, Input: input, Copy: c.StopStreamRequest}
}

// StopStreamRequest is the request type for the
// StopStream API operation.
type StopStreamRequest struct {
	*aws.Request
	Input *StopStreamInput
	Copy  func(*StopStreamInput) StopStreamRequest
}

// Send marshals and sends the StopStream API request.
func (r StopStreamRequest) Send(ctx context.Context) (*StopStreamResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopStreamResponse{
		StopStreamOutput: r.Request.Data.(*StopStreamOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopStreamResponse is the response type for the
// StopStream API operation.
type StopStreamResponse struct {
	*StopStreamOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopStream request.
func (r *StopStreamResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
