// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kendra

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type SubmitFeedbackInput struct {
	_ struct{} `type:"structure"`

	// Tells Amazon Kendra that a particular search result link was chosen by the
	// user.
	ClickFeedbackItems []ClickFeedback `type:"list"`

	// The identifier of the index that was queried.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The identifier of the specific query for which you are submitting feedback.
	// The query ID is returned in the response to the operation.
	//
	// QueryId is a required field
	QueryId *string `min:"1" type:"string" required:"true"`

	// Provides Amazon Kendra with relevant or not relevant feedback for whether
	// a particular item was relevant to the search.
	RelevanceFeedbackItems []RelevanceFeedback `type:"list"`
}

// String returns the string representation
func (s SubmitFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubmitFeedbackInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SubmitFeedbackInput"}

	if s.IndexId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexId", 36))
	}

	if s.QueryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("QueryId"))
	}
	if s.QueryId != nil && len(*s.QueryId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("QueryId", 1))
	}
	if s.ClickFeedbackItems != nil {
		for i, v := range s.ClickFeedbackItems {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ClickFeedbackItems", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.RelevanceFeedbackItems != nil {
		for i, v := range s.RelevanceFeedbackItems {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RelevanceFeedbackItems", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SubmitFeedbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SubmitFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

const opSubmitFeedback = "SubmitFeedback"

// SubmitFeedbackRequest returns a request value for making API operation for
// AWSKendraFrontendService.
//
// Enables you to provide feedback to Amazon Kendra to improve the performance
// of the service.
//
//    // Example sending a request using SubmitFeedbackRequest.
//    req := client.SubmitFeedbackRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/SubmitFeedback
func (c *Client) SubmitFeedbackRequest(input *SubmitFeedbackInput) SubmitFeedbackRequest {
	op := &aws.Operation{
		Name:       opSubmitFeedback,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SubmitFeedbackInput{}
	}

	req := c.newRequest(op, input, &SubmitFeedbackOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return SubmitFeedbackRequest{Request: req, Input: input, Copy: c.SubmitFeedbackRequest}
}

// SubmitFeedbackRequest is the request type for the
// SubmitFeedback API operation.
type SubmitFeedbackRequest struct {
	*aws.Request
	Input *SubmitFeedbackInput
	Copy  func(*SubmitFeedbackInput) SubmitFeedbackRequest
}

// Send marshals and sends the SubmitFeedback API request.
func (r SubmitFeedbackRequest) Send(ctx context.Context) (*SubmitFeedbackResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SubmitFeedbackResponse{
		SubmitFeedbackOutput: r.Request.Data.(*SubmitFeedbackOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SubmitFeedbackResponse is the response type for the
// SubmitFeedback API operation.
type SubmitFeedbackResponse struct {
	*SubmitFeedbackOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SubmitFeedback request.
func (r *SubmitFeedbackResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
