// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesis

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Represents the input for IncreaseStreamRetentionPeriod.
type IncreaseStreamRetentionPeriodInput struct {
	_ struct{} `type:"structure"`

	// The new retention period of the stream, in hours. Must be more than the current
	// retention period.
	//
	// RetentionPeriodHours is a required field
	RetentionPeriodHours *int64 `min:"1" type:"integer" required:"true"`

	// The name of the stream to modify.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s IncreaseStreamRetentionPeriodInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IncreaseStreamRetentionPeriodInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IncreaseStreamRetentionPeriodInput"}

	if s.RetentionPeriodHours == nil {
		invalidParams.Add(aws.NewErrParamRequired("RetentionPeriodHours"))
	}
	if s.RetentionPeriodHours != nil && *s.RetentionPeriodHours < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("RetentionPeriodHours", 1))
	}

	if s.StreamName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type IncreaseStreamRetentionPeriodOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s IncreaseStreamRetentionPeriodOutput) String() string {
	return awsutil.Prettify(s)
}

const opIncreaseStreamRetentionPeriod = "IncreaseStreamRetentionPeriod"

// IncreaseStreamRetentionPeriodRequest returns a request value for making API operation for
// Amazon Kinesis.
//
// Increases the Kinesis data stream's retention period, which is the length
// of time data records are accessible after they are added to the stream. The
// maximum value of a stream's retention period is 168 hours (7 days).
//
// If you choose a longer stream retention period, this operation increases
// the time period during which records that have not yet expired are accessible.
// However, it does not make previous, expired data (older than the stream's
// previous retention period) accessible after the operation has been called.
// For example, if a stream's retention period is set to 24 hours and is increased
// to 168 hours, any data that is older than 24 hours remains inaccessible to
// consumer applications.
//
//    // Example sending a request using IncreaseStreamRetentionPeriodRequest.
//    req := client.IncreaseStreamRetentionPeriodRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/IncreaseStreamRetentionPeriod
func (c *Client) IncreaseStreamRetentionPeriodRequest(input *IncreaseStreamRetentionPeriodInput) IncreaseStreamRetentionPeriodRequest {
	op := &aws.Operation{
		Name:       opIncreaseStreamRetentionPeriod,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IncreaseStreamRetentionPeriodInput{}
	}

	req := c.newRequest(op, input, &IncreaseStreamRetentionPeriodOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return IncreaseStreamRetentionPeriodRequest{Request: req, Input: input, Copy: c.IncreaseStreamRetentionPeriodRequest}
}

// IncreaseStreamRetentionPeriodRequest is the request type for the
// IncreaseStreamRetentionPeriod API operation.
type IncreaseStreamRetentionPeriodRequest struct {
	*aws.Request
	Input *IncreaseStreamRetentionPeriodInput
	Copy  func(*IncreaseStreamRetentionPeriodInput) IncreaseStreamRetentionPeriodRequest
}

// Send marshals and sends the IncreaseStreamRetentionPeriod API request.
func (r IncreaseStreamRetentionPeriodRequest) Send(ctx context.Context) (*IncreaseStreamRetentionPeriodResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &IncreaseStreamRetentionPeriodResponse{
		IncreaseStreamRetentionPeriodOutput: r.Request.Data.(*IncreaseStreamRetentionPeriodOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// IncreaseStreamRetentionPeriodResponse is the response type for the
// IncreaseStreamRetentionPeriod API operation.
type IncreaseStreamRetentionPeriodResponse struct {
	*IncreaseStreamRetentionPeriodOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// IncreaseStreamRetentionPeriod request.
func (r *IncreaseStreamRetentionPeriodResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
