// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesis

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RegisterStreamConsumerInput struct {
	_ struct{} `type:"structure"`

	// For a given Kinesis data stream, each consumer must have a unique name. However,
	// consumer names don't have to be unique across data streams.
	//
	// ConsumerName is a required field
	ConsumerName *string `min:"1" type:"string" required:"true"`

	// The ARN of the Kinesis data stream that you want to register the consumer
	// with. For more info, see Amazon Resource Names (ARNs) and AWS Service Namespaces
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams).
	//
	// StreamARN is a required field
	StreamARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterStreamConsumerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterStreamConsumerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegisterStreamConsumerInput"}

	if s.ConsumerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConsumerName"))
	}
	if s.ConsumerName != nil && len(*s.ConsumerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConsumerName", 1))
	}

	if s.StreamARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("StreamARN"))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RegisterStreamConsumerOutput struct {
	_ struct{} `type:"structure"`

	// An object that represents the details of the consumer you registered. When
	// you register a consumer, it gets an ARN that is generated by Kinesis Data
	// Streams.
	//
	// Consumer is a required field
	Consumer *Consumer `type:"structure" required:"true"`
}

// String returns the string representation
func (s RegisterStreamConsumerOutput) String() string {
	return awsutil.Prettify(s)
}

const opRegisterStreamConsumer = "RegisterStreamConsumer"

// RegisterStreamConsumerRequest returns a request value for making API operation for
// Amazon Kinesis.
//
// Registers a consumer with a Kinesis data stream. When you use this operation,
// the consumer you register can read data from the stream at a rate of up to
// 2 MiB per second. This rate is unaffected by the total number of consumers
// that read from the same stream.
//
// You can register up to 5 consumers per stream. A given consumer can only
// be registered with one stream.
//
// This operation has a limit of five transactions per second per account.
//
//    // Example sending a request using RegisterStreamConsumerRequest.
//    req := client.RegisterStreamConsumerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/RegisterStreamConsumer
func (c *Client) RegisterStreamConsumerRequest(input *RegisterStreamConsumerInput) RegisterStreamConsumerRequest {
	op := &aws.Operation{
		Name:       opRegisterStreamConsumer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterStreamConsumerInput{}
	}

	req := c.newRequest(op, input, &RegisterStreamConsumerOutput{})

	return RegisterStreamConsumerRequest{Request: req, Input: input, Copy: c.RegisterStreamConsumerRequest}
}

// RegisterStreamConsumerRequest is the request type for the
// RegisterStreamConsumer API operation.
type RegisterStreamConsumerRequest struct {
	*aws.Request
	Input *RegisterStreamConsumerInput
	Copy  func(*RegisterStreamConsumerInput) RegisterStreamConsumerRequest
}

// Send marshals and sends the RegisterStreamConsumer API request.
func (r RegisterStreamConsumerRequest) Send(ctx context.Context) (*RegisterStreamConsumerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RegisterStreamConsumerResponse{
		RegisterStreamConsumerOutput: r.Request.Data.(*RegisterStreamConsumerOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RegisterStreamConsumerResponse is the response type for the
// RegisterStreamConsumer API operation.
type RegisterStreamConsumerResponse struct {
	*RegisterStreamConsumerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RegisterStreamConsumer request.
func (r *RegisterStreamConsumerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
