// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lambda

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteProvisionedConcurrencyConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - my-function.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The version number or alias name.
	//
	// Qualifier is a required field
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProvisionedConcurrencyConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProvisionedConcurrencyConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteProvisionedConcurrencyConfigInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}

	if s.Qualifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("Qualifier"))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteProvisionedConcurrencyConfigInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Qualifier != nil {
		v := *s.Qualifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Qualifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteProvisionedConcurrencyConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteProvisionedConcurrencyConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteProvisionedConcurrencyConfigOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteProvisionedConcurrencyConfig = "DeleteProvisionedConcurrencyConfig"

// DeleteProvisionedConcurrencyConfigRequest returns a request value for making API operation for
// AWS Lambda.
//
// Deletes the provisioned concurrency configuration for a function.
//
//    // Example sending a request using DeleteProvisionedConcurrencyConfigRequest.
//    req := client.DeleteProvisionedConcurrencyConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteProvisionedConcurrencyConfig
func (c *Client) DeleteProvisionedConcurrencyConfigRequest(input *DeleteProvisionedConcurrencyConfigInput) DeleteProvisionedConcurrencyConfigRequest {
	op := &aws.Operation{
		Name:       opDeleteProvisionedConcurrencyConfig,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2019-09-30/functions/{FunctionName}/provisioned-concurrency",
	}

	if input == nil {
		input = &DeleteProvisionedConcurrencyConfigInput{}
	}

	req := c.newRequest(op, input, &DeleteProvisionedConcurrencyConfigOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteProvisionedConcurrencyConfigRequest{Request: req, Input: input, Copy: c.DeleteProvisionedConcurrencyConfigRequest}
}

// DeleteProvisionedConcurrencyConfigRequest is the request type for the
// DeleteProvisionedConcurrencyConfig API operation.
type DeleteProvisionedConcurrencyConfigRequest struct {
	*aws.Request
	Input *DeleteProvisionedConcurrencyConfigInput
	Copy  func(*DeleteProvisionedConcurrencyConfigInput) DeleteProvisionedConcurrencyConfigRequest
}

// Send marshals and sends the DeleteProvisionedConcurrencyConfig API request.
func (r DeleteProvisionedConcurrencyConfigRequest) Send(ctx context.Context) (*DeleteProvisionedConcurrencyConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteProvisionedConcurrencyConfigResponse{
		DeleteProvisionedConcurrencyConfigOutput: r.Request.Data.(*DeleteProvisionedConcurrencyConfigOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteProvisionedConcurrencyConfigResponse is the response type for the
// DeleteProvisionedConcurrencyConfig API operation.
type DeleteProvisionedConcurrencyConfigResponse struct {
	*DeleteProvisionedConcurrencyConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteProvisionedConcurrencyConfig request.
func (r *DeleteProvisionedConcurrencyConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
